/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.Executor;
import org.apache.commons.io.FilenameUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.oak.osgi.ObserverTracker;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.blob.BlobGC;
import org.apache.jackrabbit.oak.plugins.blob.BlobGCMBean;
import org.apache.jackrabbit.oak.plugins.blob.BlobGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.BlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.blob.MarkSweepGarbageCollector;
import org.apache.jackrabbit.oak.plugins.segment.SegmentBlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.ProxyNodeStore;
import org.apache.jackrabbit.oak.spi.state.RevisionGC;
import org.apache.jackrabbit.oak.spi.state.RevisionGCMBean;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardExecutor;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
public class SegmentNodeStoreService
extends ProxyNodeStore
implements Observable {
    @Property(description="The unique name of this instance")
    public static final String NAME = "name";
    @Property(description="TarMK directory")
    public static final String DIRECTORY = "repository.home";
    @Property(description="TarMK mode (64 for memory mapping, 32 for normal file access)")
    public static final String MODE = "tarmk.mode";
    @Property(description="TarMK maximum file size (MB)", intValue={256})
    public static final String SIZE = "tarmk.size";
    @Property(description="Cache size (MB)", intValue={256})
    public static final String CACHE = "cache";
    public static final String CUSTOM_BLOB_STORE = "customBlobStore";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String name;
    private SegmentStore store;
    private SegmentNodeStore delegate;
    private ObserverTracker observerTracker;
    private ComponentContext context;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private volatile BlobStore blobStore;
    private ServiceRegistration registration;
    private Registration revisionGCRegistration;
    private Registration blobGCRegistration;
    private WhiteboardExecutor executor;

    @Override
    protected synchronized SegmentNodeStore getNodeStore() {
        Preconditions.checkState((this.delegate != null ? 1 : 0) != 0, (Object)"service must be activated when used");
        return this.delegate;
    }

    @Activate
    private void activate(ComponentContext context) throws IOException {
        this.context = context;
        if (this.blobStore == null && Boolean.parseBoolean(SegmentNodeStoreService.lookup(context, CUSTOM_BLOB_STORE))) {
            this.log.info("BlobStore use enabled. SegmentNodeStore would be initialized when BlobStore would be available");
        } else {
            this.registerNodeStore();
        }
    }

    public synchronized void registerNodeStore() throws IOException {
        String size;
        if (this.context == null) {
            this.log.info("Component still not activated. Ignoring the initialization call");
            return;
        }
        Dictionary properties = this.context.getProperties();
        this.name = String.valueOf(properties.get(NAME));
        String directory = SegmentNodeStoreService.lookup(this.context, DIRECTORY);
        directory = directory == null ? "tarmk" : FilenameUtils.concat((String)directory, (String)"segmentstore");
        String mode = SegmentNodeStoreService.lookup(this.context, MODE);
        if (mode == null) {
            mode = System.getProperty(MODE, System.getProperty("sun.arch.data.model", "32"));
        }
        if ((size = SegmentNodeStoreService.lookup(this.context, SIZE)) == null) {
            size = System.getProperty(SIZE, "256");
        }
        this.store = new FileStore(this.blobStore, new File(directory), Integer.parseInt(size), "64".equals(mode));
        this.delegate = new SegmentNodeStore(this.store);
        this.observerTracker = new ObserverTracker(this.delegate);
        this.observerTracker.start(this.context.getBundleContext());
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", SegmentNodeStore.class.getName());
        this.registration = this.context.getBundleContext().registerService(NodeStore.class.getName(), (Object)this, props);
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(this.context.getBundleContext());
        this.executor = new WhiteboardExecutor();
        this.executor.start(whiteboard);
        RevisionGC revisionGC = new RevisionGC(new Runnable(){

            @Override
            public void run() {
                SegmentNodeStoreService.this.store.gc();
            }
        }, this.executor);
        this.revisionGCRegistration = WhiteboardUtils.registerMBean(whiteboard, RevisionGCMBean.class, revisionGC, "RevisionGarbageCollection", "Segment node store revision garbage collection");
        if (this.blobStore instanceof GarbageCollectableBlobStore) {
            BlobGarbageCollector gc = new BlobGarbageCollector(){

                public void collectGarbage() throws Exception {
                    MarkSweepGarbageCollector gc = new MarkSweepGarbageCollector((BlobReferenceRetriever)new SegmentBlobReferenceRetriever(SegmentNodeStoreService.this.store.getTracker()), (GarbageCollectableBlobStore)SegmentNodeStoreService.this.blobStore, (Executor)SegmentNodeStoreService.this.executor);
                    gc.collectGarbage();
                }
            };
            this.blobGCRegistration = WhiteboardUtils.registerMBean(whiteboard, BlobGCMBean.class, new BlobGC(gc, (Executor)this.executor), "BlobGarbageCollection", "Segment node store blob garbage collection");
        }
        this.log.info("SegmentNodeStore initialized");
    }

    private static String lookup(ComponentContext context, String property) {
        if (context.getProperties().get(property) != null) {
            return context.getProperties().get(property).toString();
        }
        if (context.getBundleContext().getProperty(property) != null) {
            return context.getBundleContext().getProperty(property);
        }
        return null;
    }

    @Deactivate
    public synchronized void deactivate() {
        this.unregisterNodeStore();
        this.observerTracker.stop();
        this.delegate = null;
        this.store.close();
        this.store = null;
    }

    protected void bindBlobStore(BlobStore blobStore) throws IOException {
        this.log.info("Initializing SegmentNodeStore with BlobStore [{}]", (Object)blobStore);
        this.blobStore = blobStore;
        this.registerNodeStore();
    }

    protected void unbindBlobStore(BlobStore blobStore) {
        this.blobStore = null;
        this.unregisterNodeStore();
    }

    private void unregisterNodeStore() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        if (this.revisionGCRegistration != null) {
            this.revisionGCRegistration.unregister();
            this.revisionGCRegistration = null;
        }
        if (this.blobGCRegistration != null) {
            this.blobGCRegistration.unregister();
            this.blobGCRegistration = null;
        }
        if (this.executor != null) {
            this.executor.stop();
            this.executor = null;
        }
    }

    public SegmentStore getSegmentStore() {
        return this.store;
    }

    @Override
    public Closeable addObserver(Observer observer) {
        return this.getNodeStore().addObserver(observer);
    }

    public String toString() {
        return this.name + ": " + this.delegate;
    }
}

