/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigHelper {
    private static final Logger log = LoggerFactory.getLogger(ConfigHelper.class);
    private Map defaultPackages = new HashMap();
    private Map defaultClasses = new HashMap();
    private Map<String, String> mappings = new HashMap<String, String>();

    public Map getDefaultPackages() {
        return this.defaultPackages;
    }

    public Map getDefaultClasses() {
        return this.defaultClasses;
    }

    protected Map<String, String> getMappings() {
        return this.mappings;
    }

    public String getDefaultPackage(String name) {
        return (String)this.defaultPackages.get(name);
    }

    public String getDefaultClass(String name) {
        return (String)this.defaultClasses.get(name);
    }

    public Object create(Element elem) throws ConfigurationException {
        String className = elem.getAttribute("class");
        if (className == null || className.equals("")) {
            className = (String)this.defaultClasses.get(elem.getNodeName());
        }
        if (className == null || className.equals("")) {
            return elem.getFirstChild().getNodeValue();
        }
        String field = null;
        int pos = className.indexOf(35);
        if (pos > 0) {
            field = className.substring(pos + 1);
            className = className.substring(0, pos);
        }
        Class<?> clazz = null;
        try {
            clazz = this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz == null) {
            if (className.indexOf(46) < 0) {
                String pack = (String)this.defaultPackages.get(elem.getNodeName());
                if (pack == null) {
                    throw new ConfigurationException("Default package for class attribute of " + elem.getNodeName() + " missing.");
                }
                className = pack + "." + className;
            }
            if (this.mappings.containsKey(className)) {
                className = this.mappings.get(className);
            }
            try {
                clazz = this.getClass().getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Error while creating instance for " + elem.getNodeName(), e);
            }
        }
        try {
            if (field == null) {
                return clazz.newInstance();
            }
            return clazz.getField(field).get(null);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Error while creating instance for " + elem.getNodeName(), e);
        }
        catch (NoSuchFieldException e) {
            throw new ConfigurationException("Error while creating instance for " + elem.getNodeName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Error while creating instance for " + elem.getNodeName(), e);
        }
    }

    public static String getMethodName(String prefix, String name) {
        return prefix + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static Method getMethod(Object obj, String name, Class ... params) {
        Method[] ms;
        for (Method m : ms = obj.getClass().getMethods()) {
            Class<?>[] pt;
            if (!m.getName().equals(name) || (pt = m.getParameterTypes()).length != params.length) continue;
            for (int j = 0; j < params.length; ++j) {
                if (params[j].isAssignableFrom(pt[j])) continue;
                m = null;
                break;
            }
            if (m == null) continue;
            return m;
        }
        return null;
    }

    public static boolean hasSetter(Object obj, String name) throws ConfigurationException {
        String setter = ConfigHelper.getMethodName("set", name);
        if (ConfigHelper.getMethod(obj, setter, Object.class) != null) {
            log.debug("Has setter {} on {}", (Object)name, obj);
            return true;
        }
        log.debug("{} has no setter for {}", obj, (Object)name);
        return false;
    }

    public static boolean setField(Object obj, String name, Object value) throws ConfigurationException {
        if (name.equals("class")) {
            return false;
        }
        String setter = ConfigHelper.getMethodName("set", name);
        try {
            Method m = ConfigHelper.getMethod(obj, setter, Object.class);
            if (m == null) {
                log.error("{} has no setter for {}", obj, (Object)name);
                throw new ConfigurationException(obj + " has not setter for " + name);
            }
            m.invoke(obj, value);
            log.debug("Setting {} on {}", (Object)name, obj);
            return true;
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Unable to set " + setter + " of " + obj, e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException("Unable to set " + setter + " of " + obj, e);
        }
    }

    public static <T> T invokeGetter(Object obj, String name, Class<T> T) throws ConfigurationException {
        try {
            String getter = ConfigHelper.getMethodName("get", name);
            Method m = obj.getClass().getMethod(getter, new Class[0]);
            if (T.isAssignableFrom(m.getReturnType())) {
                return (T)m.invoke(obj, new Object[0]);
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            log.debug("{} has no field {} or type " + T, obj, (Object)name);
            return null;
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Unable to get list " + name + " of " + obj);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException("Unable to get list " + name + " of " + obj);
        }
    }
}

