/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.util.Map;
import java.util.TreeMap;
import org.apache.jackrabbit.vault.util.PathComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportInfo {
    private final TreeMap<String, Entry> entries = new TreeMap(new PathComparator(true));

    public void update(Type type, String path) {
        Entry e = this.entries.get(path);
        if (e == null) {
            e = new Entry(type, path);
        } else if (e.type != Type.ADD) {
            e = new Entry(type, path);
        }
        this.entries.put(path, e);
    }

    public Map<String, Entry> getEntries() {
        return this.entries;
    }

    public static class Entry {
        public final Type type;
        public final String path;

        public Entry(Type type, String path) {
            this.type = type;
            this.path = path;
        }

        public String toString() {
            return (Object)((Object)this.type) + " " + this.path;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ADD,
        DELETE,
        UPDATE,
        MKDIR,
        RMDIR,
        NOP;

    }
}

