/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.packaging.CyclicDependencyException;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyUtil {
    private static final Logger log = LoggerFactory.getLogger(DependencyUtil.class);

    public static <T extends VaultPackage> void sort(Collection<T> packages) throws CyclicDependencyException {
        LinkedHashMap<PackageId, Dependency[]> list = new LinkedHashMap<PackageId, Dependency[]>();
        LinkedHashMap<PackageId, VaultPackage> byId = new LinkedHashMap<PackageId, VaultPackage>();
        for (VaultPackage pack : packages) {
            list.put(pack.getId(), pack.getDependencies());
            byId.put(pack.getId(), pack);
        }
        packages.clear();
        for (PackageId id : DependencyUtil.resolve(list)) {
            packages.add((VaultPackage)byId.remove(id));
        }
    }

    public static <T extends JcrPackage> void sortPackages(Collection<T> packages) throws CyclicDependencyException, RepositoryException {
        LinkedHashMap<PackageId, Dependency[]> list = new LinkedHashMap<PackageId, Dependency[]>();
        LinkedHashMap<PackageId, JcrPackage> byId = new LinkedHashMap<PackageId, JcrPackage>();
        for (JcrPackage pack : packages) {
            PackageId id = pack.getDefinition().getId();
            list.put(id, pack.getDefinition().getDependencies());
            byId.put(id, pack);
        }
        packages.clear();
        for (PackageId id : DependencyUtil.resolve(list)) {
            packages.add((JcrPackage)byId.remove(id));
        }
    }

    public static List<PackageId> resolve(Map<PackageId, Dependency[]> list) throws CyclicDependencyException {
        Dependency[] fake = new Dependency[list.size()];
        int i = 0;
        for (Map.Entry<PackageId, Dependency[]> entry : list.entrySet()) {
            fake[i++] = new Dependency(entry.getKey());
        }
        LinkedHashMap<PackageId, Boolean> result = new LinkedHashMap<PackageId, Boolean>(list.size());
        DependencyUtil.resolve(fake, list, result);
        return new ArrayList<PackageId>(result.keySet());
    }

    private static void resolve(Dependency[] deps, Map<PackageId, Dependency[]> list, Map<PackageId, Boolean> result) throws CyclicDependencyException {
        for (Dependency dep : deps) {
            for (Map.Entry<PackageId, Dependency[]> entry : list.entrySet()) {
                PackageId id = entry.getKey();
                if (!dep.matches(id)) continue;
                Boolean res = result.get(id);
                if (res != null && !res.booleanValue()) {
                    log.error("Package dependencies cause cycle.");
                    throw new CyclicDependencyException();
                }
                if (res == null) {
                    res = false;
                    result.put(id, res);
                }
                DependencyUtil.resolve(entry.getValue(), list, result);
                if (res.booleanValue()) continue;
                result.remove(id);
                result.put(id, true);
            }
        }
    }
}

