/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.util.XMLChar;
import org.apache.jackrabbit.value.ValueHelper;
import org.apache.jackrabbit.vault.util.Constants;
import org.apache.jackrabbit.vault.util.Text;
import org.apache.jackrabbit.vault.util.ValueComparator;

public class DocViewProperty {
    public final String name;
    public final String[] values;
    public final boolean isMulti;
    public final int type;
    private static final Set<String> UNAMBIGOUS = new HashSet<String>();

    public DocViewProperty(String name, String[] values, boolean multi, int type) {
        this.name = name;
        this.values = values;
        this.isMulti = multi;
        if (type == 0 && (name.equals("jcr:primaryType") || name.equals("jcr:mixinTypes"))) {
            type = 7;
        }
        this.type = type;
        if (!this.isMulti && values.length != 1) {
            throw new IllegalArgumentException("Single value property needs exactly 1 value.");
        }
    }

    public static DocViewProperty parse(String name, String value) {
        String[] values;
        boolean isMulti = false;
        int type = 0;
        int pos = 0;
        int state = 98;
        LinkedList<String> vals = null;
        StringBuffer tmp = new StringBuffer();
        int unicode = 0;
        int unicodePos = 0;
        while (pos < value.length()) {
            char c = value.charAt(pos++);
            switch (state) {
                case 98: {
                    if (c == '{') {
                        state = 116;
                        break;
                    }
                    if (c == '[') {
                        isMulti = true;
                        state = 118;
                        break;
                    }
                    if (c == '\\') {
                        state = 101;
                        break;
                    }
                    tmp.append(c);
                    state = 118;
                    break;
                }
                case 97: {
                    if (c == '[') {
                        isMulti = true;
                        state = 118;
                        break;
                    }
                    if (c == '\\') {
                        state = 101;
                        break;
                    }
                    tmp.append(c);
                    state = 118;
                    break;
                }
                case 116: {
                    if (c == '}') {
                        type = PropertyType.valueFromName((String)tmp.toString());
                        tmp.setLength(0);
                        state = 97;
                        break;
                    }
                    tmp.append(c);
                    break;
                }
                case 118: {
                    if (c == '\\') {
                        state = 101;
                        break;
                    }
                    if (c == ',' && isMulti) {
                        if (vals == null) {
                            vals = new LinkedList();
                        }
                        vals.add(tmp.toString());
                        tmp.setLength(0);
                        break;
                    }
                    if (c == ']' && isMulti && pos == value.length()) {
                        if (tmp.length() <= 0 && vals == null) break;
                        if (vals == null) {
                            vals = new LinkedList();
                        }
                        vals.add(tmp.toString());
                        tmp.setLength(0);
                        break;
                    }
                    tmp.append(c);
                    break;
                }
                case 101: {
                    if (c == 'u') {
                        state = 117;
                        unicode = 0;
                        unicodePos = 0;
                        break;
                    }
                    if (c == '0') {
                        state = 118;
                        if (vals != null) break;
                        vals = new LinkedList();
                        break;
                    }
                    state = 118;
                    tmp.append(c);
                    break;
                }
                case 117: {
                    unicode = (unicode << 4) + Character.digit(c, 16);
                    if (++unicodePos != 4) break;
                    tmp.appendCodePoint(unicode);
                    state = 118;
                }
            }
        }
        if (isMulti) {
            if (tmp.length() > 0) {
                if (vals == null) {
                    vals = new LinkedList<String>();
                }
                vals.add(tmp.toString());
            }
            values = vals == null ? Constants.EMPTY_STRING_ARRAY : vals.toArray(new String[vals.size()]);
        } else {
            values = new String[]{tmp.toString()};
        }
        return new DocViewProperty(name, values, isMulti, type);
    }

    public static String format(Property prop) throws RepositoryException {
        return DocViewProperty.format(prop, false);
    }

    public static String format(Property prop, boolean sort) throws RepositoryException {
        StringBuffer attrValue = new StringBuffer();
        int type = prop.getType();
        if (type == 2 || DocViewProperty.isAmbiguous(prop)) {
            attrValue.append("{");
            attrValue.append(PropertyType.nameFromValue((int)prop.getType()));
            attrValue.append("}");
        }
        if (prop.getType() != 2) {
            if (prop.getDefinition().isMultiple()) {
                attrValue.append('[');
                Value[] values = prop.getValues();
                if (sort) {
                    Arrays.sort(values, ValueComparator.getInstance());
                }
                block3: for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        attrValue.append(',');
                    }
                    String strValue = ValueHelper.serialize(values[i], false);
                    if (values.length == 1 && strValue.length() == 0) {
                        attrValue.append("\\0");
                        continue;
                    }
                    switch (prop.getType()) {
                        case 1: 
                        case 7: 
                        case 8: {
                            DocViewProperty.escape(attrValue, strValue, true);
                            continue block3;
                        }
                        default: {
                            attrValue.append(strValue);
                        }
                    }
                }
                attrValue.append(']');
            } else {
                String strValue = ValueHelper.serialize(prop.getValue(), false);
                DocViewProperty.escape(attrValue, strValue, false);
            }
        }
        return attrValue.toString();
    }

    protected static void escape(StringBuffer buf, String value, boolean isMulti) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                buf.append("\\\\");
                continue;
            }
            if (c == ',' && isMulti) {
                buf.append("\\,");
                continue;
            }
            if (!(i != 0 || isMulti || c != '[' && c != '{')) {
                buf.append('\\').append(c);
                continue;
            }
            if (XMLChar.isInvalid(c)) {
                buf.append("\\u");
                buf.append(Text.hexTable[c >> 12 & 0xF]);
                buf.append(Text.hexTable[c >> 8 & 0xF]);
                buf.append(Text.hexTable[c >> 4 & 0xF]);
                buf.append(Text.hexTable[c & 0xF]);
                continue;
            }
            buf.append(c);
        }
    }

    public static boolean isAmbiguous(Property prop) throws RepositoryException {
        return prop.getType() != 1 && !UNAMBIGOUS.contains(prop.getName());
    }

    public boolean apply(Node node) throws RepositoryException {
        Value v;
        int propType;
        Property prop;
        Property property = prop = node.hasProperty(this.name) ? node.getProperty(this.name) : null;
        if (prop != null && this.isMulti != prop.getDefinition().isMultiple()) {
            prop.remove();
            prop = null;
        }
        if (prop != null && (propType = prop.getType()) != this.type && (propType != 1 || this.type != 0)) {
            prop = null;
        }
        if (this.isMulti) {
            Value[] vs;
            Value[] valueArray = vs = prop == null ? null : prop.getValues();
            if (vs != null && vs.length == this.values.length) {
                boolean modified = false;
                for (int i = 0; i < vs.length; ++i) {
                    if (vs[i].getString().equals(this.values[i])) continue;
                    modified = true;
                }
                if (!modified) {
                    return false;
                }
            }
            if (this.type == 0) {
                node.setProperty(this.name, this.values);
            } else {
                node.setProperty(this.name, this.values, this.type);
            }
            return true;
        }
        Value value = v = prop == null ? null : prop.getValue();
        if (v == null || !v.getString().equals(this.values[0])) {
            try {
                if (this.type == 0) {
                    node.setProperty(this.name, this.values[0]);
                } else {
                    node.setProperty(this.name, this.values[0], this.type);
                }
            }
            catch (ValueFormatException e) {
                node.setProperty(this.name, this.values[0], 1);
            }
            return true;
        }
        return false;
    }

    static {
        UNAMBIGOUS.add("jcr:primaryType");
        UNAMBIGOUS.add("jcr:mixinTypes");
    }
}

