/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMetadata
extends HashMap<String, Object> {
    private static final long serialVersionUID = 4692666752269523738L;
    public static final String RESOLUTION_PATH = "sling.resolutionPath";
    public static final String RESOLUTION_PATH_INFO = "sling.resolutionPathInfo";
    public static final String CONTENT_TYPE = "sling.contentType";
    public static final String CONTENT_LENGTH = "sling.contentLength";
    public static final String CHARACTER_ENCODING = "sling.characterEncoding";
    public static final String CREATION_TIME = "sling.creationTime";
    public static final String MODIFICATION_TIME = "sling.modificationTime";
    public static final String INTERNAL_CONTINUE_RESOLVING = ":org.apache.sling.resource.internal.continue.resolving";
    private boolean isReadOnly = false;
    private volatile transient Set<Map.Entry<String, Object>> lockedEntrySet;
    private transient Set<String> lockedKeySet;
    private transient Collection<Object> lockedValues;

    public void setCharacterEncoding(String encoding) {
        if (encoding != null) {
            this.put(CHARACTER_ENCODING, (Object)encoding);
        }
    }

    public String getCharacterEncoding() {
        Object value = this.get(CHARACTER_ENCODING);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public void setContentType(String contentType) {
        if (contentType != null) {
            this.put(CONTENT_TYPE, (Object)contentType);
        }
    }

    public String getContentType() {
        Object value = this.get(CONTENT_TYPE);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public void setContentLength(long contentLength) {
        if (contentLength > 0L) {
            this.put(CONTENT_LENGTH, (Object)contentLength);
        }
    }

    public long getContentLength() {
        Object value = this.get(CONTENT_LENGTH);
        if (value instanceof Long) {
            return (Long)value;
        }
        return -1L;
    }

    public void setCreationTime(long creationTime) {
        if (creationTime >= 0L) {
            this.put(CREATION_TIME, (Object)creationTime);
        }
    }

    public long getCreationTime() {
        Object value = this.get(CREATION_TIME);
        if (value instanceof Long) {
            return (Long)value;
        }
        return -1L;
    }

    public void setModificationTime(long modificationTime) {
        if (modificationTime >= 0L) {
            this.put(MODIFICATION_TIME, (Object)modificationTime);
        }
    }

    public long getModificationTime() {
        Object value = this.get(MODIFICATION_TIME);
        if (value instanceof Long) {
            return (Long)value;
        }
        return -1L;
    }

    public void setResolutionPath(String resolutionPath) {
        if (resolutionPath != null) {
            this.put(RESOLUTION_PATH, (Object)resolutionPath);
        }
    }

    public String getResolutionPath() {
        Object value = this.get(RESOLUTION_PATH);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public void setResolutionPathInfo(String resolutionPathInfo) {
        if (resolutionPathInfo != null) {
            this.put(RESOLUTION_PATH_INFO, (Object)resolutionPathInfo);
        }
    }

    public String getResolutionPathInfo() {
        Object value = this.get(RESOLUTION_PATH_INFO);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public void lock() {
        this.isReadOnly = true;
    }

    private void checkReadOnly() {
        if (this.isReadOnly) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is locked");
        }
    }

    @Override
    public void clear() {
        this.checkReadOnly();
        super.clear();
    }

    @Override
    public Object put(String key, Object value) {
        this.checkReadOnly();
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.checkReadOnly();
        super.putAll(m);
    }

    @Override
    public Object remove(Object key) {
        this.checkReadOnly();
        return super.remove(key);
    }

    @Override
    public Object clone() {
        ResourceMetadata result = (ResourceMetadata)super.clone();
        result.lockedEntrySet = null;
        result.lockedKeySet = null;
        result.lockedValues = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLockedData() {
        if (this.isReadOnly && this.lockedEntrySet == null) {
            ResourceMetadata resourceMetadata = this;
            synchronized (resourceMetadata) {
                if (this.isReadOnly && this.lockedEntrySet == null) {
                    this.lockedEntrySet = Collections.unmodifiableSet(super.entrySet());
                    this.lockedKeySet = Collections.unmodifiableSet(super.keySet());
                    this.lockedValues = Collections.unmodifiableCollection(super.values());
                }
            }
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.getLockedData();
        return this.lockedEntrySet != null ? this.lockedEntrySet : super.entrySet();
    }

    @Override
    public Set<String> keySet() {
        this.getLockedData();
        return this.lockedKeySet != null ? this.lockedKeySet : super.keySet();
    }

    @Override
    public Collection<Object> values() {
        this.getLockedData();
        return this.lockedValues != null ? this.lockedValues : super.values();
    }
}

