/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery;

import org.apache.sling.discovery.TopologyView;

public class TopologyEvent {
    private final Type type;
    private final TopologyView oldView;
    private final TopologyView newView;

    public TopologyEvent(Type type, TopologyView oldView, TopologyView newView) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (type == Type.TOPOLOGY_INIT) {
            if (oldView != null) {
                throw new IllegalArgumentException("oldView must be null");
            }
            if (newView == null) {
                throw new IllegalArgumentException("newView must not be null");
            }
        } else if (type == Type.TOPOLOGY_CHANGING) {
            if (newView != null) {
                throw new IllegalArgumentException("newView must be null");
            }
            if (oldView == null) {
                throw new IllegalArgumentException("oldView must not be null");
            }
        } else {
            if (oldView == null) {
                throw new IllegalArgumentException("oldView must not be null");
            }
            if (newView == null) {
                throw new IllegalArgumentException("newView must not be null");
            }
        }
        this.type = type;
        this.oldView = oldView;
        this.newView = newView;
    }

    public Type getType() {
        return this.type;
    }

    public TopologyView getOldView() {
        return this.oldView;
    }

    public TopologyView getNewView() {
        return this.newView;
    }

    public String toString() {
        return "TopologyEvent [type=" + (Object)((Object)this.type) + ", oldView=" + this.oldView + ", newView=" + this.newView + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        TOPOLOGY_INIT,
        TOPOLOGY_CHANGING,
        TOPOLOGY_CHANGED,
        PROPERTIES_CHANGED;

    }
}

