/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base;

import aQute.bnd.annotation.ProviderType;
import java.util.Dictionary;
import javax.jcr.Repository;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.AbstractSlingRepository2;
import org.apache.sling.jcr.base.NamespaceMappingSupport;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProviderType
public abstract class AbstractSlingRepositoryManager
extends NamespaceMappingSupport {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private BundleContext bundleContext;
    private Repository repository;
    private AbstractSlingRepository2 masterSlingRepository;
    private ServiceRegistration repositoryService;
    private String defaultWorkspace;
    private boolean disableLoginAdministrative;

    public final String getDefaultWorkspace() {
        return this.defaultWorkspace;
    }

    public final boolean isDisableLoginAdministrative() {
        return this.disableLoginAdministrative;
    }

    protected abstract ServiceUserMapper getServiceUserMapper();

    protected abstract Repository acquireRepository();

    protected final ServiceRegistration registerService() {
        Dictionary<String, Object> props = this.getServiceRegistrationProperties();
        String[] interfaces = this.getServiceRegistrationInterfaces();
        return this.bundleContext.registerService(interfaces, (Object)new ServiceFactory(){

            public Object getService(Bundle bundle, ServiceRegistration registration) {
                return AbstractSlingRepositoryManager.this.create(bundle);
            }

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
                AbstractSlingRepositoryManager.this.destroy((AbstractSlingRepository2)service);
            }
        }, props);
    }

    protected abstract Dictionary<String, Object> getServiceRegistrationProperties();

    protected String[] getServiceRegistrationInterfaces() {
        return new String[]{SlingRepository.class.getName(), Repository.class.getName()};
    }

    protected abstract AbstractSlingRepository2 create(Bundle var1);

    protected abstract void destroy(AbstractSlingRepository2 var1);

    protected final Repository getRepository() {
        return this.repository;
    }

    protected final void unregisterService(ServiceRegistration serviceRegistration) {
        serviceRegistration.unregister();
    }

    protected abstract void disposeRepository(Repository var1);

    protected final boolean start(BundleContext bundleContext, String defaultWorkspace, boolean disableLoginAdministrative) {
        if (this.bundleContext != null) {
            this.log.debug("start: Repository already started and registered");
            return true;
        }
        this.bundleContext = bundleContext;
        this.defaultWorkspace = defaultWorkspace;
        this.disableLoginAdministrative = disableLoginAdministrative;
        try {
            this.log.debug("start: calling acquireRepository()");
            Repository newRepo = this.acquireRepository();
            if (newRepo != null) {
                this.log.debug("start: got a Repository");
                this.repository = newRepo;
                this.masterSlingRepository = this.create(this.bundleContext.getBundle());
                this.log.debug("start: setting up NamespaceMapping support");
                this.setup(this.bundleContext, this.masterSlingRepository);
                this.log.debug("start: calling registerService()");
                this.repositoryService = this.registerService();
                this.log.debug("start: registerService() successful, registration=" + this.repositoryService);
                return true;
            }
        }
        catch (Throwable t) {
            this.log.error("start: Uncaught Throwable trying to access Repository, calling stopRepository()", t);
            this.stop();
        }
        return false;
    }

    protected final void stop() {
        if (this.repository != null || this.repositoryService != null) {
            this.log.info("stop: Repository still running, forcing shutdown");
            try {
                if (this.repositoryService != null) {
                    try {
                        this.log.debug("stop: Unregistering SlingRepository service, registration=" + this.repositoryService);
                        this.unregisterService(this.repositoryService);
                    }
                    catch (Throwable t) {
                        this.log.info("stop: Uncaught problem unregistering the repository service", t);
                    }
                    this.repositoryService = null;
                }
                if (this.repository != null) {
                    Repository oldRepo = this.repository;
                    this.repository = null;
                    this.tearDown();
                    this.destroy(this.masterSlingRepository);
                    try {
                        this.disposeRepository(oldRepo);
                    }
                    catch (Throwable t) {
                        this.log.info("stop: Uncaught problem disposing the repository", t);
                    }
                }
            }
            catch (Throwable t) {
                this.log.warn("stop: Unexpected problem stopping repository", t);
            }
        }
        this.repositoryService = null;
        this.repository = null;
        this.defaultWorkspace = null;
        this.bundleContext = null;
    }
}

