/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base;

import aQute.bnd.annotation.ProviderType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.jcr.api.NamespaceMapper;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.SessionProxyHandler;
import org.apache.sling.jcr.base.internal.loader.Loader;
import org.osgi.framework.BundleContext;

@ProviderType
public abstract class NamespaceMappingSupport {
    private Loader namespaceHandler;
    private SessionProxyHandler sessionProxyHandler;

    protected abstract NamespaceMapper[] getNamespaceMapperServices();

    private SessionProxyHandler getSessionProxyHandler() {
        return this.sessionProxyHandler;
    }

    private Loader getLoader() {
        return this.namespaceHandler;
    }

    protected void setup(BundleContext bundleContext, SlingRepository repository) {
        this.sessionProxyHandler = new SessionProxyHandler(this);
        this.namespaceHandler = new Loader(repository, bundleContext);
    }

    protected void tearDown() {
        if (this.namespaceHandler != null) {
            this.namespaceHandler.dispose();
            this.namespaceHandler = null;
        }
        this.sessionProxyHandler = null;
    }

    final void defineNamespacePrefixes(Session session) throws RepositoryException {
        NamespaceMapper[] nsMappers;
        Loader localHandler = this.getLoader();
        if (localHandler != null) {
            localHandler.defineNamespacePrefixes(session);
        }
        if ((nsMappers = this.getNamespaceMapperServices()) != null) {
            for (int i = 0; i < nsMappers.length; ++i) {
                nsMappers[i].defineNamespacePrefixes(session);
            }
        }
    }

    protected final Session getNamespaceAwareSession(Session session) throws RepositoryException {
        if (session == null) {
            return null;
        }
        this.defineNamespacePrefixes(session);
        SessionProxyHandler localHandler = this.getSessionProxyHandler();
        if (localHandler != null) {
            return localHandler.createProxy(session);
        }
        return session;
    }
}

