/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.jackrabbit.commons.cnd.CndImporter;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeLoader {
    private static final Logger log = LoggerFactory.getLogger(NodeTypeLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerNodeType(Session session, URL source) {
        if (source == null) {
            log.info("No node type definition source available");
            return false;
        }
        InputStream ins = null;
        try {
            ins = source.openStream();
            boolean bl = NodeTypeLoader.registerNodeType(session, ins);
            return bl;
        }
        catch (IOException ioe) {
            log.error("Cannot register node types from " + source, (Throwable)ioe);
        }
        catch (RepositoryException re) {
            if (NodeTypeLoader.isReRegisterBuiltinNodeType((Exception)((Object)re))) {
                log.debug("Attempt to re-register built-in node type from " + source, (Throwable)re);
            } else {
                log.error("Cannot register node types from " + source, (Throwable)re);
            }
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ignore) {}
            }
        }
        return false;
    }

    public static boolean registerNodeType(Session session, InputStream source) throws IOException, RepositoryException {
        return NodeTypeLoader.registerNodeType(session, "cnd input stream", new InputStreamReader(source), false);
    }

    public static boolean registerNodeType(Session session, String systemId, Reader reader, boolean reregisterExisting) throws IOException, RepositoryException {
        try {
            Workspace wsp = session.getWorkspace();
            CndImporter.registerNodeTypes(reader, systemId, wsp.getNodeTypeManager(), wsp.getNamespaceRegistry(), session.getValueFactory(), reregisterExisting);
        }
        catch (RepositoryException re) {
            if (NodeTypeLoader.isReRegisterBuiltinNodeType((Exception)((Object)re))) {
                log.debug("Attempt to re-register built-in node type, RepositoryException ignored", (Throwable)re);
            }
            throw re;
        }
        catch (ParseException e) {
            throw new IOException("Unable to parse CND Input: " + e.getMessage());
        }
        return true;
    }

    static boolean isReRegisterBuiltinNodeType(Exception e) {
        return e instanceof RepositoryException & (e.getMessage() != null && e.getMessage().contains("reregister built-in node type"));
    }
}

