/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceaccesssecurity;

import aQute.bnd.annotation.ConsumerType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.security.AccessSecurityException;

@ConsumerType
public interface ResourceAccessGate {
    public static final String SERVICE_NAME = ResourceAccessGate.class.getName();
    public static final String CONTEXT = "access.context";
    public static final String APPLICATION_CONTEXT = "application";
    public static final String PROVIDER_CONTEXT = "provider";
    public static final String PATH = "path";
    public static final String OPERATIONS = "operations";
    public static final String FINALOPERATIONS = "finaloperations";

    public GateResult canRead(Resource var1);

    public GateResult canCreate(String var1, ResourceResolver var2);

    public GateResult canUpdate(Resource var1);

    public GateResult canDelete(Resource var1);

    public GateResult canExecute(Resource var1);

    public GateResult canReadValue(Resource var1, String var2);

    public GateResult canCreateValue(Resource var1, String var2);

    public GateResult canUpdateValue(Resource var1, String var2);

    public GateResult canDeleteValue(Resource var1, String var2);

    public String transformQuery(String var1, String var2, ResourceResolver var3) throws AccessSecurityException;

    public boolean hasReadRestrictions(ResourceResolver var1);

    public boolean hasCreateRestrictions(ResourceResolver var1);

    public boolean hasUpdateRestrictions(ResourceResolver var1);

    public boolean hasDeleteRestrictions(ResourceResolver var1);

    public boolean hasExecuteRestrictions(ResourceResolver var1);

    public boolean canReadAllValues(Resource var1);

    public boolean canCreateAllValues(Resource var1);

    public boolean canUpdateAllValues(Resource var1);

    public boolean canDeleteAllValues(Resource var1);

    public static enum Operation {
        READ("read"),
        CREATE("create"),
        UPDATE("update"),
        DELETE("delete"),
        EXECUTE("execute");

        private String text;

        private Operation(String text) {
            this.text = text;
        }

        public static Operation fromString(String opAsString) {
            Operation returnValue = null;
            for (Operation op : Operation.values()) {
                if (!opAsString.equals(op.getText())) continue;
                returnValue = op;
                break;
            }
            return returnValue;
        }

        public String getText() {
            return this.text;
        }
    }

    public static enum GateResult {
        GRANTED,
        DENIED,
        CANT_DECIDE;

    }
}

