/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib;

import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptToTag
extends TagSupport {
    private static final Logger log = LoggerFactory.getLogger(AdaptToTag.class);
    private static final long serialVersionUID = -1945089681840552408L;
    private Adaptable adaptable;
    private String adaptTo;
    private String var;

    public int doEndTag() {
        log.trace("doEndTag");
        ClassLoader classLoader = this.getClassLoader();
        log.debug("Adapting adaptable " + this.adaptable + " to class " + this.adaptTo);
        if (this.adaptable != null) {
            Object adapted = null;
            try {
                Class<?> adaptToClass = classLoader.loadClass(this.adaptTo);
                adapted = this.adaptable.adaptTo(adaptToClass);
            }
            catch (ClassNotFoundException e) {
                log.warn("Unable to retrieve class " + this.adaptTo, (Throwable)e);
            }
            log.debug("Saving " + adapted + " to variable " + this.var);
            this.pageContext.setAttribute(this.var, adapted);
        } else {
            log.warn("Null adaptable specified");
        }
        return 6;
    }

    public Adaptable getAdaptable() {
        return this.adaptable;
    }

    public String getAdaptTo() {
        return this.adaptTo;
    }

    protected ClassLoader getClassLoader() {
        SlingBindings bindings = (SlingBindings)this.pageContext.getRequest().getAttribute(SlingBindings.class.getName());
        SlingScriptHelper scriptHelper = bindings.getSling();
        DynamicClassLoaderManager dynamicClassLoaderManager = scriptHelper.getService(DynamicClassLoaderManager.class);
        ClassLoader classLoader = dynamicClassLoaderManager.getDynamicClassLoader();
        return classLoader;
    }

    public String getVar() {
        return this.var;
    }

    public void setAdaptable(Adaptable adaptable) {
        this.adaptable = adaptable;
    }

    public void setAdaptTo(String adaptTo) {
        this.adaptTo = adaptTo;
    }

    public void setVar(String var) {
        this.var = var;
    }
}

