/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.servlets.post.HtmlResponse;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.PostResponseCreator;

@Component
@Service
public class PostResponseWithErrorHandling
implements PostResponseCreator {
    public PostResponse createPostResponse(SlingHttpServletRequest request) {
        if (this.isSendError(request)) {
            return new HtmlResponse(){

                protected void doSend(HttpServletResponse response) throws IOException {
                    if (!this.isSuccessful()) {
                        response.sendError(this.getStatusCode(), this.getError().toString());
                        return;
                    }
                    super.doSend(response);
                }
            };
        }
        return null;
    }

    protected boolean isSendError(SlingHttpServletRequest request) {
        boolean sendError = false;
        String sendErrorParam = request.getParameter(":sendError");
        if (sendErrorParam != null && "true".equalsIgnoreCase(sendErrorParam)) {
            sendError = true;
        }
        return sendError;
    }
}

