/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.JsonClient;
import com.adobe.cq.testing.client.WorkflowClient;
import com.adobe.cq.testing.client.workflow.EventType;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.codehaus.jackson.JsonNode;

public class CQWorkflowClient
extends WorkflowClient {
    public static final String LAUNCHER_CONFIG = "/etc/workflow/launcher/config/";
    public static final String ROOT_PATH_MODEL = "/etc/workflow/models/";
    public static final String CQ_MODEL_PAGE_TEMPLATE = "/libs/cq/workflow/templates/model";
    public static final String SAVE_SUFFIX = "/jcr:content.generate.json";
    CQClient cqClient = (CQClient)this.adaptTo(CQClient.class);

    public CQWorkflowClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public CQWorkflowClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public SlingHttpResponse createNewModelPage(String modelName, String modelTitle, int ... expectedStatusRange) throws ClientException {
        return this.cqClient.createPage(modelName, modelTitle, ROOT_PATH_MODEL, CQ_MODEL_PAGE_TEMPLATE, expectedStatusRange);
    }

    public SlingHttpResponse saveModel(String modelPath, int ... expectedStatus) throws ClientException {
        return this.doPost(modelPath + SAVE_SUFFIX, null, expectedStatus);
    }

    public void createWorkflowLauncher(String workflowId, String path, String nodeType, EventType eventType) throws ClientException {
        UrlEncodedFormEntity form = FormEntityBuilder.create().addParameter("_charset_", "utf-8").addParameter("add", "true").addParameter("eventType", String.valueOf((Object)eventType)).addParameter("nodetype", nodeType).addParameter("glob", path).addParameter("condition", "").addParameter("workflow", workflowId).addParameter("enabled", "true").addParameter("runModes", "author").addParameter(":status", "browser").addParameter("description", "").addParameter("excludeList", "").build();
        this.doPost("/libs/cq/workflow/launcher", (HttpEntity)form, new int[]{200});
    }

    public void editWorkflowLauncher(String launcherId, String propName, String value) throws ClientException {
        HashMap<String, String> wv = new HashMap<String, String>();
        wv.put(propName, value);
        this.editWorkflowLauncher(launcherId, wv);
    }

    public void editWorkflowLauncher(String launcherId, Map<String, String> propMap) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create();
        form.addParameter("_charset_", "utf-8");
        form.addParameter(":status", "browser");
        form.addParameter("edit", LAUNCHER_CONFIG + launcherId);
        Map<String, String> launcher = this.getWorkflowLauncher(launcherId);
        for (String launcherProp : launcher.keySet()) {
            if (propMap.containsKey(launcherProp)) continue;
            form.addParameter(launcherProp, launcher.get(launcherProp));
        }
        for (String propName : propMap.keySet()) {
            form.addParameter(propName, propMap.get(propName));
        }
        if (!propMap.keySet().contains("excludeList")) {
            form.addParameter("excludeList", "");
        }
        this.doPost("/libs/cq/workflow/launcher", (HttpEntity)form.build(), new int[]{200});
    }

    public Map<String, String> getWorkflowLauncher(String launcherId) throws ClientException {
        JsonNode launchers = this.doGetJson("/etc/workflow/launcher/config", 1, new int[0]);
        JsonNode launcherNode = launchers.get(launcherId);
        if (null == launcherNode) {
            return null;
        }
        HashMap<String, String> launcher = new HashMap<String, String>();
        Iterator it = launcherNode.getFieldNames();
        while (it.hasNext()) {
            String propName = (String)it.next();
            launcher.put(propName, launcherNode.get(propName).getValueAsText());
        }
        return launcher;
    }

    public void enableDisableWorkflowLauncher(String launcherId, boolean enabled) throws ClientException {
        this.editWorkflowLauncher(launcherId, "enabled", enabled ? "true" : "false");
    }

    public boolean isWorkflowTransient(String workflowModel) throws ClientException {
        workflowModel = workflowModel.startsWith(ROOT_PATH_MODEL) ? workflowModel : ROOT_PATH_MODEL + workflowModel;
        workflowModel = workflowModel.endsWith("/jcr:content") ? workflowModel : workflowModel + "/jcr:content";
        JsonNode json = ((JsonClient)this.adaptTo(JsonClient.class)).doGetJson(workflowModel, 0, new int[0]);
        return !json.path("transient").isMissingNode() && json.get("transient").getValueAsText().equalsIgnoreCase("true");
    }
}

