/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.JsonClient;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.SlingParameter;
import org.codehaus.jackson.JsonNode;

public class CommunityClient
extends CQClient {
    public CommunityClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public CommunityClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public SlingHttpResponse addCommentsComponent(String pagePath, int ... expectedStatus) throws ClientException {
        String postPath = pagePath + "/jcr:content/par/";
        FormEntityBuilder feb = FormEntityBuilder.create();
        feb.addParameter("./sling:resourceType", "social/commons/components/comments");
        feb.addParameter(":nameHint", "comments");
        feb.addParameter(":order", "last");
        return this.doPost(postPath, (HttpEntity)feb.build(), HttpUtils.getExpectedStatus((int)201, (int[])expectedStatus));
    }

    public SlingHttpResponse configureCommentComponent(String commentPath, String defaultMessage, boolean isModerated, boolean allowReplies, boolean displayAsTree, boolean closed, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create();
        for (NameValuePair val : new SlingParameter("./allowRepliesToComments").value(Boolean.valueOf(allowReplies).toString()).delete().typeHint("Boolean").toNameValuePairs()) {
            feb.addParameter(val.getName(), val.getValue());
        }
        for (NameValuePair val : new SlingParameter("./moderateComments").value(Boolean.valueOf(isModerated).toString()).typeHint("Boolean").delete().toNameValuePairs()) {
            feb.addParameter(val.getName(), val.getValue());
        }
        for (NameValuePair val : new SlingParameter("./displayCommentsAsTree").value(Boolean.valueOf(displayAsTree).toString()).typeHint("Boolean").delete().toNameValuePairs()) {
            feb.addParameter(val.getName(), val.getValue());
        }
        for (NameValuePair val : new SlingParameter("./closed").value(Boolean.valueOf(closed).toString()).typeHint("Boolean").delete().toNameValuePairs()) {
            feb.addParameter(val.getName(), val.getValue());
        }
        for (NameValuePair val : new SlingParameter("./defaultMessage").value(defaultMessage).toNameValuePairs()) {
            feb.addParameter(val.getName(), val.getValue());
        }
        return this.doPost(commentPath, (HttpEntity)feb.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse moderateComment(String commentPath, boolean approve, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.moderateComment(commentPath, approve, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse markCommentAsSpam(String commentPath, boolean isSpam, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.markCommentAsSpam(commentPath, isSpam, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse editComment(String command, String commentPath, int ... expectedStatus) throws ClientException {
        switch (command) {
            case "approve": {
                return this.wcmCommands.moderateComment(commentPath, true, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
            }
            case "deny": {
                return this.wcmCommands.moderateComment(commentPath, false, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
            }
            case "markCommentAsSpam": {
                return this.wcmCommands.markCommentAsSpam(commentPath, true, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
            }
            case "deleteComment": {
                return this.wcmCommands.deleteComment(commentPath, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
            }
        }
        return null;
    }

    public JsonNode createComment(String commentPath, String comment, String user, String url, String email, int ... expectedStatus) throws ClientException {
        String postPath = commentPath + ".social.createcomment.json";
        SlingHttpResponse exec = this.doPost(postPath, (HttpEntity)FormEntityBuilder.create().addParameter("email", email).addParameter("id", "nobot").addParameter("jcr:description", comment).addParameter("url", url).addParameter("userIdentifier", user).addParameter(":templatename", "comment").build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return JsonUtils.getJsonNodeFromString((String)exec.getContent());
    }

    public JsonNode getComments(String ugcBasePath, int limit, int start, String predicate, String view) throws ClientException {
        return ((JsonClient)this.adaptTo(JsonClient.class)).getUserGeneratedPages(ugcBasePath, limit, start, predicate, view);
    }

    public SlingHttpResponse deleteComment(String commentPath, int ... expectedStatus) throws ClientException {
        String postPath = "/bin/wcmcommand";
        return this.doPost(postPath, (HttpEntity)FormEntityBuilder.create().addParameter("cmd", "deleteComment").addParameter("path", commentPath).build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }
}

