/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;

public class FormClient
extends CQClient {
    public FormClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public FormClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public SlingHttpResponse doFormPost(String path, String sessionCookie, String formId, String formStart, String redirect, Map<String, String> parameters, String ... expectedValidationErrors) throws ClientException {
        redirect = this.getUrl(redirect).getPath();
        UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter(":formid", formId).addParameter(":formstart", formStart).addParameter(":redirect", redirect).addParameter("_charset_", "UTF-8").addAllParameters(parameters).build();
        List<Header> headers = Arrays.asList(new BasicHeader("Cookie", sessionCookie), new BasicHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8"));
        SlingHttpResponse exec = this.doPost(path, (HttpEntity)entity, headers, new int[]{200, 302});
        String response = exec.getContent();
        String[] parts = response.split("<[^>]*class=\"[^\"]*form_error[^\"]*\"[^>]*>");
        ArrayList<String> validationErrors = new ArrayList<String>();
        for (int i = 1; i < parts.length; ++i) {
            validationErrors.add(parts[i].substring(0, parts[i].indexOf("</")));
        }
        String globalMessage = "Please correct the errors and send your information again.";
        ArrayList<String> expectedErrors = new ArrayList<String>(Arrays.asList(expectedValidationErrors));
        if (expectedErrors.size() > 0 && !expectedErrors.contains("Please correct the errors and send your information again.")) {
            expectedErrors.add("Please correct the errors and send your information again.");
        }
        Collection<String> unexpectedErrors = FormClient.subtract(validationErrors, expectedErrors);
        Collection<String> missingErrors = FormClient.subtract(expectedErrors, validationErrors);
        if (!unexpectedErrors.isEmpty()) {
            throw new ClientException("Unexpected form validation errors!\r" + StringUtils.join(unexpectedErrors, (String)"\r"));
        }
        if (!missingErrors.isEmpty()) {
            throw new ClientException("Expected form validation error missing!\r" + StringUtils.join(missingErrors, (String)"\r"));
        }
        return exec;
    }

    private static Collection<String> subtract(Collection<String> a, Collection<String> b) {
        ArrayList<String> list = new ArrayList<String>(a);
        for (String aB : b) {
            list.remove(aB);
        }
        return list;
    }
}

