/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.notification.Notification;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.URLParameterBuilder;
import org.codehaus.jackson.JsonNode;

public class NotificationClient
extends CQClient {
    public static final String NOTIFICATION_INBOX_PATH = "/libs/wcm/core/content/inbox.html";
    public static final String NOTIFICATION_CHANNEL_INBOX = "inbox";
    public static final String NOTIFICATION_CHANNEL_EMAIL = "email";
    public static final String NOTIFICATION_CONFIG_PATH = "/bin/wcm/notification/config";
    public static final String NOTIFICATIONS_SUBSCRIPTIONS_PATH = "/home/users/geometrixx/author/wcm/notification/config/subscriptions";
    public static final String NOTIFICATION_MESSAGES_PATH = "/bin/wcm/notification/inbox/messages";
    private static final String NOTIFICATION_ACTION_PATH = "/bin/wcm/notification/inbox/action.json";
    private static final String NOTIFICATIONS_DIALOG_OPTIONS_PATH = "/libs/cq/ui/widgets.js";
    public static final String NOTIFICATION_ACTION_ACTIVATE = "ACTIVATE";
    public static final String NOTIFICATION_ACTION_DEACTIVATE = "DEACTIVATE";
    public static final String NOTIFICATION_ACTION_DELETE = "DELETE";
    public static final String NOTIFICATION_ACTION_PAGE_MODIFIED = "PageModified";
    public static final String NOTIFICATION_ACTION_PAGE_CREATED = "PageCreated";
    public static final String NOTIFICATION_ACTION_PAGE_DELETED = "PageDeleted";
    public static final String NOTIFICATION_ACTION_PAGE_ROLLED_OUT = "PageRolledOut";

    public NotificationClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public NotificationClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public ArrayList<String> getAvailableNotificationAction() throws ClientException {
        ArrayList<String> actions = null;
        SlingHttpResponse exec = this.doGet(NOTIFICATIONS_DIALOG_OPTIONS_PATH, new int[]{200});
        String widgetJs = exec.getContent();
        String notifPart = widgetJs.substring(widgetJs.indexOf("CQ.wcm.NotificationInbox"), widgetJs.indexOf("CQ.Ext.reg(\"notificationinbox\", CQ.wcm.NotificationInbox);"));
        Pattern p = Pattern.compile("CQ\\.wcm\\.NotificationInbox = .+var options = (\\[.+\\]);.+", 32);
        Matcher m = p.matcher(notifPart);
        if (m.find()) {
            actions = new ArrayList<String>();
            String optionsJson = m.group(1).replace("value:", "\"value\":").replace("text:", "\"text\":").replace("CQ.I18n.getMessage(", "").replace(")", "");
            JsonNode options = JsonUtils.getJsonNodeFromString((String)optionsJson);
            Iterator it = options.getElements();
            while (it.hasNext()) {
                JsonNode option = (JsonNode)it.next();
                actions.add(option.get("value").getValueAsText());
            }
        }
        return actions;
    }

    public ArrayList<Notification> getNotificationMessages() throws ClientException {
        return this.getNotificationMessages(-1, -1);
    }

    public ArrayList<Notification> getNotificationMessages(int start, int limit) throws ClientException {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        URLParameterBuilder params = URLParameterBuilder.create();
        if (start > -1) {
            params.add("start", String.valueOf(start));
        }
        if (limit > -1) {
            params.add("limit", String.valueOf(limit));
        }
        SlingHttpResponse exec = this.doGet("/bin/wcm/notification/inbox/messages.json", params.getList(), new int[]{200});
        JsonNode messages = JsonUtils.getJsonNodeFromString((String)exec.getContent()).get("messages");
        Iterator it = messages.getElements();
        while (it.hasNext()) {
            JsonNode message = (JsonNode)it.next();
            Notification notification = new Notification(message);
            notifications.add(notification);
        }
        return notifications;
    }

    public void resetConfig() throws ClientException {
        if (this.exists(NOTIFICATIONS_SUBSCRIPTIONS_PATH)) {
            this.deletePath(NOTIFICATIONS_SUBSCRIPTIONS_PATH, new int[0]);
        }
    }

    public SlingHttpResponse configNotifications(String channel, String[] actions, String packages, int ... expectedStatus) throws ClientException {
        FormEntityBuilder formEntry = FormEntityBuilder.create();
        formEntry.addParameter("type", channel);
        for (String action : actions) {
            formEntry.addParameter("actions", action);
        }
        formEntry.addParameter("configs", packages);
        return this.doPost("/bin/wcm/notification/config.json", (HttpEntity)formEntry.build(), expectedStatus);
    }

    public SlingHttpResponse getNotificationInboxPage(int ... expectedStatus) throws ClientException {
        return this.doGet(NOTIFICATION_INBOX_PATH, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse approveNotification(Notification notification, int ... expectedStatus) throws ClientException {
        return this.performAction(notification, "approve", expectedStatus);
    }

    public SlingHttpResponse deleteNotification(Notification notification, int ... expectedStatus) throws ClientException {
        return this.performAction(notification, "delete", expectedStatus);
    }

    public void deleteNotifications(ArrayList<Notification> notifications, int ... expectedStatus) throws ClientException {
        for (Notification n : notifications) {
            this.deleteNotification(n, expectedStatus);
        }
    }

    public void deleteAllNotifications() throws ClientException {
        this.deleteNotifications(this.getNotificationMessages(), 200);
    }

    public SlingHttpResponse performAction(Notification notification, String action, int ... expectedStatus) throws ClientException {
        FormEntityBuilder formEntry = FormEntityBuilder.create();
        if (notification != null) {
            formEntry.addParameter("path", notification.getId());
        }
        if (action != null) {
            formEntry.addParameter("cmd", action);
        }
        return this.doPost(NOTIFICATION_ACTION_PATH, (HttpEntity)formEntry.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }
}

