/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.ResourceUtil;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;

public class PackageManagerClient
extends CQClient {
    public PackageManagerClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public PackageManagerClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public Package createPackage(String name, String version, String group) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create();
        feb.addParameter("cmd", "create");
        feb.addParameter("_charset_", "utf-8");
        feb.addParameter("groupName", group);
        feb.addParameter("packageName", name);
        if (version != null) {
            feb.addParameter("packageVersion", version);
        }
        this.doPost("/crx/packmgr/service/exec.json", (HttpEntity)feb.build(), new int[]{200});
        return new Package(this, name, version, group);
    }

    public Package getPackage(String path) throws ClientException {
        return new Package(this, path);
    }

    public Package uploadPackage(InputStream is, String fileName) throws ClientException {
        JsonNode root;
        HttpEntity mpe = MultipartEntityBuilder.create().addPart("package", (ContentBody)new InputStreamBody(is, fileName)).addTextBody("force", "true").addTextBody("_charset_", "UTF-8").addTextBody("cmd", "upload").addTextBody("jsonInTextarea", "true").build();
        SlingHttpResponse exec = this.doPost("/crx/packmgr/service/exec.json", mpe, new int[]{200});
        ObjectMapper mapper = new ObjectMapper();
        try {
            root = mapper.readTree(exec.getContent().replaceAll("</?textarea>", ""));
        }
        catch (Exception ex) {
            throw new ClientException("Unable to parse JSON response to upload request.", (Throwable)ex);
        }
        if (!root.get("success").getBooleanValue()) {
            throw new ClientException(root.get("msg").getTextValue());
        }
        return new Package(this, root.get("path").getTextValue());
    }

    public SlingHttpResponse createPackage(String packageName, String packageVersion, String groupName, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("_charset_", "utf-8").addParameter("packageName", packageName).addParameter("packageVersion", packageVersion).addParameter("cmd", "create").addParameter("groupName", groupName);
        return this.doPost("/crx/packmgr/service/exec.json", (HttpEntity)feb.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse deletePackage(String packageName, String packageVersion, String groupName, int ... expectedStatus) throws ClientException {
        String url = "/crx/packmgr/service/script.html/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip";
        MultipartEntityBuilder multiPartEntity = MultipartEntityBuilder.create().addTextBody("cmd", "delete").addTextBody("callback", "window.parent.Ext.Ajax.Stream.callback");
        return this.doPost(url, multiPartEntity.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse renamePackages(String oldName, String oldVersion, String oldGroup, String newName, String newVersion, String newGroup, int ... expectedStatus) throws ClientException {
        String oldPath = "/etc/packages/" + oldGroup + "/" + oldName + "-" + oldVersion + ".zip";
        HttpEntity multiPartEntity = MultipartEntityBuilder.create().addTextBody("path", oldPath).addTextBody("packageName", newName).addTextBody("groupName", newGroup).addTextBody("version", newVersion).addTextBody("_charset_", "UTF-8").build();
        return this.doPost("/crx/packmgr/update.jsp", multiPartEntity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public boolean isPackageCreated(String packageName, String packageVersion, String groupName) throws ClientException {
        return this.exists("/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip");
    }

    public SlingHttpResponse buildPackage(String packageName, String packageVersion, String groupName, int ... expectedStatus) throws ClientException {
        String postURL = "/crx/packmgr/service/script.html/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip";
        HttpEntity multiPartEntity = MultipartEntityBuilder.create().addTextBody("cmd", "build").addTextBody("callback", "window.parent.Ext.Ajax.Stream.callback").build();
        return this.doPost(postURL, multiPartEntity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse rewrapPackage(String packageName, String packageVersion, String groupName, int ... expectedStatus) throws ClientException {
        String postURL = "/crx/packmgr/service/script.html/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip";
        HttpEntity multiPartEntity = MultipartEntityBuilder.create().addTextBody("cmd", "rewrap").addTextBody("callback", "window.parent.Ext.Ajax.Stream.callback").build();
        return this.doPost(postURL, multiPartEntity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse installPackage(String packageName, String packageVersion, String groupName, int ... expectedStatus) throws ClientException {
        String postURL = "/crx/packmgr/service/script.html/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip";
        HttpEntity multiPartEntity = MultipartEntityBuilder.create().addTextBody("cmd", "install").addTextBody("callback", "window.parent.Ext.Ajax.Stream.callback").addTextBody("autosave", "1024").addTextBody("recursive", "true").build();
        return this.doPost(postURL, multiPartEntity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse uninstallPackage(String packageName, String packageVersion, String groupName, int ... expectedStatus) throws ClientException {
        String postURL = "/crx/packmgr/service/script.html/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip";
        HttpEntity multiPartEntity = MultipartEntityBuilder.create().addTextBody("cmd", "uninstall").addTextBody("callback", "window.parent.Ext.Ajax.Stream.callback").build();
        return this.doPost(postURL, multiPartEntity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse testInstallPackage(String packageName, String packageVersion, String groupName, int ... expectedStatus) throws ClientException {
        String postURL = "/crx/packmgr/service/script.html/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip";
        HttpEntity multiPartEntity = MultipartEntityBuilder.create().addTextBody("cmd", "dryrun").addTextBody("callback", "window.parent.Ext.Ajax.Stream.callback").build();
        return this.doPost(postURL, multiPartEntity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse uploadPackage(String resourcePath, String fileName, int ... expectedStatus) throws ClientException {
        String postURL = "/crx/packmgr/service/exec.json";
        HttpEntity multiPartEntity = MultipartEntityBuilder.create().addBinaryBody("package", ResourceUtil.getResourceAsStream((String)resourcePath), ContentType.create((String)"application/x-zip-compressed"), fileName).addTextBody("force", "true").addTextBody("_charset_", "UTF-8").addTextBody("cmd", "upload").build();
        return this.doPost(postURL, multiPartEntity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public String getPackageContentResponse(String packageName, String packageVersion, String groupName) throws ClientException {
        String postURL = "/crx/packmgr/service/script.html/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip";
        HttpEntity multiPartEntity = MultipartEntityBuilder.create().addTextBody("cmd", "contents").addTextBody("callback", "window.parent.Ext.Ajax.Stream.callback").build();
        return this.doPost(postURL, multiPartEntity, new int[0]).getContent();
    }

    public String getPackageCoverageResponse(String packageName, String packageVersion, String groupName) throws ClientException {
        String postURL = "/crx/packmgr/service/script.html/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip";
        HttpEntity multiPartEntity = MultipartEntityBuilder.create().addTextBody("cmd", "preview").addTextBody("callback", "window.parent.Ext.Ajax.Stream.callback").build();
        return this.doPost(postURL, multiPartEntity, new int[0]).getContent();
    }

    public SlingHttpResponse updateThumbnail(String packageName, String packageVersion, String groupName, String resourcePath, String fileName, int ... expectedStatus) throws ClientException {
        String postURL = "/crx/packmgr/update.jsp";
        HttpEntity multiPartEntity = MultipartEntityBuilder.create().addTextBody("path", "/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip").addTextBody("packageName", packageName).addTextBody("groupName", groupName).addTextBody("version", packageVersion).addTextBody("_charset_", "UTF-8").addBinaryBody("thumbnail", ResourceUtil.getResourceAsStream((String)resourcePath), ContentType.create((String)"image/jpeg"), fileName).build();
        return this.doPost(postURL, multiPartEntity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse uploadPictureAsScreenshot(String packageName, String packageVersion, String groupName, String resourcePath, String fileName, int ... expectedStatus) throws ClientException {
        String postURL = "/crx/packmgr/update.jsp";
        HttpEntity multiPartEntity = MultipartEntityBuilder.create().addTextBody("path", "/etc/packages/" + groupName + "/" + packageName + "-" + packageVersion + ".zip").addTextBody("packageName", packageName).addTextBody("groupName", groupName).addTextBody("version", packageVersion).addTextBody("_charset_", "UTF-8").addBinaryBody("screenshot", ResourceUtil.getResourceAsStream((String)resourcePath), ContentType.create((String)"image/jpeg"), fileName).addTextBody("screenshotConfig", "[{\"upload\":true}])").build();
        return this.doPost(postURL, multiPartEntity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public static class Package {
        PackageManagerClient pm;
        String path;
        String name;
        String version;
        boolean versionUpdated;
        String group;
        String description;
        String filter;
        Date created;
        Date lastModified;
        Date lastWrapped;
        String lastWrappedBy;
        Date lastUnwrapped;
        String lastUnwrappedBy;
        Date lastUnpacked;
        String lastUnpackedBy;
        Boolean requiresRestart;
        Boolean requiresRoot;
        Integer buildCount;
        String builtWith;

        protected Package(PackageManagerClient pm, String name, String version, String group) {
            this.init(name, version, group, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }

        protected Package(PackageManagerClient pm, String path) throws ClientException {
            this.pm = pm;
            this.initAll(path);
        }

        public static Package build(String definitionJson) throws ClientException {
            Package p = new Package(null, "dummyName", "dummyVersion", "dummyGroup");
            p.initFromJson(definitionJson);
            return p;
        }

        private void initAll(String path) throws ClientException {
            this.checkValidPackagePath(path);
            this.initFromJson(this.getDefinition(path));
        }

        private void checkValidPackagePath(String path) {
            String regexp = "/etc/packages/([^/]+)/([^\\-.]+)-?(.*).zip";
            Matcher re = Pattern.compile(regexp).matcher(path);
            if (!re.matches()) {
                throw new IllegalArgumentException("The path supplied does not look like a path to a package. It is expected to match " + regexp);
            }
        }

        private void initFromJson(String json) throws ClientException {
            JsonNode node;
            try {
                ObjectMapper mapper = new ObjectMapper();
                node = mapper.readTree(json);
            }
            catch (JsonProcessingException e) {
                throw new ClientException("Unable to parse package properties json: " + json, (Throwable)e);
            }
            catch (IOException e) {
                throw new ClientException("Unable to read package properties.", (Throwable)e);
            }
            this.init(Package.getJsonStringSafely(node, "name"), Package.getJsonStringSafely(node, "version"), Package.getJsonStringSafely(node, "group"), Package.getJsonStringSafely(node, "jcr:description"), Package.getJsonStringSafely(node, "filter"), Package.getJsonDateSafely(node, "jcr:created"), Package.getJsonDateSafely(node, "jcr:lastModified"), Package.getJsonDateSafely(node, "lastWrapped"), Package.getJsonStringSafely(node, "lastWrappedBy"), Package.getJsonDateSafely(node, "lastUnwrapped"), Package.getJsonStringSafely(node, "lastUnwrappedBy"), Package.getJsonDateSafely(node, "lastUnpacked"), Package.getJsonStringSafely(node, "lastUnpackedBy"), Package.getJsonBooleanSafely(node, "requiresRestart"), Package.getJsonBooleanSafely(node, "requiresRoot"), Package.getJsonIntegerSafely(node, "buildCount"), Package.getJsonStringSafely(node, "builtWith"));
        }

        private void init(String name, String version, String group, String description, String filter, Date created, Date lastModified, Date lastWrapped, String lastWrappedBy, Date lastUnwrapped, String lastUnwrappedBy, Date lastUnpacked, String lastUnpackedBy, Boolean requiresRestart, Boolean requiresRoot, Integer buildCount, String builtWith) {
            this.name = name;
            this.version = version;
            this.group = group;
            this.description = description;
            this.filter = filter;
            this.path = this.buildPath();
            this.created = created;
            this.lastModified = lastModified;
            this.lastWrapped = lastWrapped;
            this.lastWrappedBy = lastWrappedBy;
            this.lastUnwrapped = lastUnwrapped;
            this.lastUnwrappedBy = lastUnwrappedBy;
            this.lastUnpacked = lastUnpacked;
            this.lastUnpackedBy = lastUnpackedBy;
            this.requiresRestart = requiresRestart;
            this.requiresRoot = requiresRoot;
            this.buildCount = buildCount;
            this.builtWith = builtWith;
            this.versionUpdated = false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Package aPackage = (Package)o;
            if (this.path != null ? !this.path.equals(aPackage.path) : aPackage.path != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(aPackage.name) : aPackage.name != null) {
                return false;
            }
            if (this.version != null ? !this.version.equals(aPackage.version) : aPackage.version != null) {
                return false;
            }
            if (this.group != null ? !this.group.equals(aPackage.group) : aPackage.group != null) {
                return false;
            }
            if (this.description != null ? !this.description.equals(aPackage.description) : aPackage.description != null) {
                return false;
            }
            if (this.filter != null ? !this.filter.equals(aPackage.filter) : aPackage.filter != null) {
                return false;
            }
            if (this.requiresRestart != null ? !this.requiresRestart.equals(aPackage.requiresRestart) : aPackage.requiresRestart != null) {
                return false;
            }
            if (this.requiresRoot != null ? !this.requiresRoot.equals(aPackage.requiresRoot) : aPackage.requiresRoot != null) {
                return false;
            }
            if (this.buildCount != null ? !this.buildCount.equals(aPackage.buildCount) : aPackage.buildCount != null) {
                return false;
            }
            return !(this.builtWith == null ? aPackage.builtWith != null : !this.builtWith.equals(aPackage.builtWith));
        }

        public int hashCode() {
            int result = this.path != null ? this.path.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
            result = 31 * result + (this.requiresRestart != null ? this.requiresRestart.hashCode() : 0);
            result = 31 * result + (this.requiresRoot != null ? this.requiresRoot.hashCode() : 0);
            result = 31 * result + (this.buildCount != null ? this.buildCount.hashCode() : 0);
            result = 31 * result + (this.builtWith != null ? this.builtWith.hashCode() : 0);
            return result;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getFilter() {
            return this.filter;
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
            this.versionUpdated = true;
        }

        public String getPath() {
            return this.path;
        }

        public Integer getBuildCount() {
            return this.buildCount;
        }

        public String getBuiltWith() {
            return this.builtWith;
        }

        public Date getCreated() {
            return this.created;
        }

        public Date getLastModified() {
            return this.lastModified;
        }

        public Date getLastUnpacked() {
            return this.lastUnpacked;
        }

        public String getLastUnpackedBy() {
            return this.lastUnpackedBy;
        }

        public Date getLastUnwrapped() {
            return this.lastUnwrapped;
        }

        public String getLastUnwrappedBy() {
            return this.lastUnwrappedBy;
        }

        public Date getLastWrapped() {
            return this.lastWrapped;
        }

        public String getLastWrappedBy() {
            return this.lastWrappedBy;
        }

        public Boolean getRequiresRestart() {
            return this.requiresRestart;
        }

        public Boolean getRequiresRoot() {
            return this.requiresRoot;
        }

        public String buildPath() {
            if (this.getName() == null || "".equals(this.getName())) {
                throw new NotImplementedException("Package name is not set.");
            }
            if (this.getGroup() == null || "".equals(this.getGroup())) {
                throw new NotImplementedException("Package group is not set.");
            }
            if (this.getVersion() == null || "".equals(this.getVersion())) {
                return String.format("/etc/packages/%s/%s.zip", this.getGroup(), this.getName());
            }
            return String.format("/etc/packages/%s/%s-%s.zip", this.getGroup(), this.getName(), this.getVersion());
        }

        public String getDefinition(String path) throws ClientException {
            return this.pm.doGet(path + "/jcr:content/vlt:definition.9.json", new int[]{200}).getContent();
        }

        public String update() throws ClientException {
            MultipartEntityBuilder meb = MultipartEntityBuilder.create();
            meb.addTextBody("path", this.getPath());
            meb.addTextBody("packageName", this.getName());
            meb.addTextBody("groupName", this.getGroup());
            if (this.getVersion() != null) {
                meb.addTextBody("version", this.getVersion());
            }
            if (this.getDescription() != null) {
                meb.addTextBody("description", this.getDescription());
            }
            if (this.getFilter() != null) {
                meb.addTextBody("filter", this.getFilter());
            }
            meb.addTextBody("_charset_", "UTF-8");
            SlingHttpResponse exec = this.pm.doPost("/crx/packmgr/update.jsp", meb.build(), new int[]{200});
            if (this.versionUpdated) {
                this.path = this.buildPath();
                this.versionUpdated = false;
            }
            return exec.getContent();
        }

        public String build() throws ClientException {
            String content = this.doScriptCmd("build").getContent();
            this.initAll(this.getPath());
            return content;
        }

        public String install() throws ClientException {
            FormEntityBuilder feb = FormEntityBuilder.create();
            feb.addParameter("cmd", "install");
            feb.addParameter("autosave", "1024");
            feb.addParameter("recursive", "true");
            feb.addParameter("acHandling", "");
            SlingHttpResponse exec = this.pm.doPost("/crx/packmgr/service/script.html" + this.getPath(), (HttpEntity)feb.build(), new int[]{200});
            String content = exec.getContent();
            this.initAll(this.getPath());
            return content;
        }

        public String replicate() throws ClientException {
            return this.doScriptCmd("replicate").getContent();
        }

        public String testInstall() throws ClientException {
            return this.doScriptCmd("dryrun").getContent();
        }

        public String unInstall() throws ClientException {
            String content = this.doScriptCmd("uninstall").getContent();
            this.initAll(this.getPath());
            return content;
        }

        public String rewrap() throws ClientException {
            String content = this.doScriptCmd("rewrap").getContent();
            this.initAll(this.getPath());
            return content;
        }

        public String getPackageContentsAsHtml() throws ClientException {
            return this.checkStatus(this.doScriptCmd("contents")).getContent();
        }

        private SlingHttpResponse checkStatus(SlingHttpResponse exec) throws ClientException {
            String content = exec.getContent();
            String statusMessage = content.replaceFirst("^.*\\(\\{\"success\":[^,]*,\"msg\":\"[^\"]*\"}\\).*$", "\\1");
            if (!statusMessage.contains("\"success\":true")) {
                throw new ClientException("The get contents request returned an error:\n" + statusMessage);
            }
            return exec;
        }

        private SlingHttpResponse doScriptCmd(String cmd) throws ClientException {
            FormEntityBuilder feb = FormEntityBuilder.create();
            feb.addParameter("cmd", cmd);
            return this.pm.doPost("/crx/packmgr/service/script.html" + this.getPath(), (HttpEntity)feb.build(), new int[]{200});
        }

        public String getPackageCoverageAsHtml() throws ClientException {
            return this.checkStatus(this.doScriptCmd("preview")).getContent();
        }

        public String delete() throws ClientException {
            return this.doScriptCmd("delete").getContent();
        }

        private static String getJsonStringSafely(JsonNode node, String attr) {
            try {
                return node.get(attr).getValueAsText();
            }
            catch (Exception e) {
                return null;
            }
        }

        private static Date getJsonDateSafely(JsonNode node, String attr) {
            try {
                String dateAsString = node.get(attr).getTextValue();
                return new SimpleDateFormat("E MMM dd yyyy HH:mm:ss 'GMT'z").parse(dateAsString);
            }
            catch (Exception e) {
                return null;
            }
        }

        private static Integer getJsonIntegerSafely(JsonNode node, String attr) {
            try {
                return Integer.parseInt(node.get(attr).getValueAsText());
            }
            catch (Exception e) {
                return null;
            }
        }

        private static Boolean getJsonBooleanSafely(JsonNode node, String attr) {
            try {
                return Boolean.parseBoolean(node.get(attr).getValueAsText());
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

