/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.components.collab;

import com.adobe.cq.testing.client.ComponentClient;
import com.adobe.cq.testing.client.components.AbstractComponent;
import com.adobe.cq.testing.client.components.collab.Rating;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.codehaus.jackson.JsonNode;

public class Ratings
extends AbstractComponent {
    public static final String RESOURCE_TYPE = "collab/commons/components/ratings";
    public static final String RATING_ELEMENT_RESOURCE_TYPE = "collab/commons/components/ratings";
    public static String GENERATED_RATINGS_PREFIX_PATH = "/content/usergenerated";
    public static final String PROP_COMMENTS_ALLOWED = "commentsAllowed";
    public static final String PROP_DATE_FORMAT = "dateFormat";
    public static final String PROP_DEFAULT_MESSAGE = "defaultMessage";
    public static final String PROP_MODERATE_COMMENTS = "moderateComments";
    public static final String PROP_SIGNED_IN_TEXT = "signedInText";
    private static final String CREATE_RATING_SUFFIX_PATH = ".createrating.html";

    public Ratings(ComponentClient client, String pagePath, String location, String nameHint) {
        super(client, pagePath, location, nameHint);
    }

    public SlingHttpResponse postRating(String description, String userIdentifier, String email, String url, int rating) throws ClientException {
        String createRatingPath = this.getComponentPath() + CREATE_RATING_SUFFIX_PATH;
        UrlEncodedFormEntity feb = FormEntityBuilder.create().addParameter("jcr:description", description).addParameter("userIdentifier", userIdentifier).addParameter("email", email).addParameter("url", url).addParameter("rating", Integer.toString(rating)).addParameter("id", "nobot").build();
        return this.client.doPost(createRatingPath, (HttpEntity)feb, new int[]{200, 302});
    }

    public String getGeneratedRatingsPath() {
        return GENERATED_RATINGS_PREFIX_PATH + this.getPagePath() + "/jcr:content/" + this.getName();
    }

    public ArrayList<Rating> getGeneratedRatings() throws ClientException {
        ArrayList<Rating> res = new ArrayList<Rating>();
        JsonNode compJson = this.client.doGetJson(this.getGeneratedRatingsPath(), -1, new int[0]);
        Iterator it = compJson.getElements();
        while (it.hasNext()) {
            JsonNode n = (JsonNode)it.next();
            if (!n.isObject() || n.get("sling:resourceType") == null || !n.get("sling:resourceType").getTextValue().equals("collab/commons/components/ratings/rating")) continue;
            Rating r = new Rating(n);
            res.add(r);
        }
        return res;
    }

    @Override
    public String getResourceType() {
        return "collab/commons/components/ratings";
    }
}

