/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.components.foundation.parsys;

import com.adobe.cq.testing.client.ComponentClient;
import com.adobe.cq.testing.client.components.AbstractComponent;
import com.adobe.cq.testing.client.components.foundation.AbstractFoundationComponent;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingHttpResponse;

public class ColCtrl
extends AbstractFoundationComponent {
    public static final String RESOURCE_TYPE = "foundation/components/parsys/colctrl";
    public static final String PROP_RESOURCE_TYPE = "sling:resourceType";
    public static final String PROP_CONTROL_TYPE = "controlType";
    public static final String PROP_LAYOUT = "layout";
    public static final String PROP_ORDER = ":order";
    public static final String COL_BREAK_CONTROL_TYPE = "break";
    public static final String COL_END_CONTROL_TYPE = "end";
    public static final String LAYOUT_2_COLS = "2;colctrl-2c";
    public static final String LAYOUT_3_COLS = "3;colctrl-3c";
    private AbstractFoundationComponent endColComponent;
    private AbstractFoundationComponent[] colBreaks;

    public ColCtrl(ComponentClient client, String pagePath, String location, String nameHint) {
        super(client, pagePath, location, nameHint);
    }

    @Override
    public SlingHttpResponse create(String order, int ... expectedStatus) throws ClientException, InterruptedException {
        SlingHttpResponse res = super.create(order, expectedStatus);
        this.endColComponent = (AbstractFoundationComponent)this.getNext();
        return res;
    }

    @Override
    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    public <T extends AbstractComponent> T addComponent(Class<T> componentClass, int colNum) throws Exception {
        String idx = this.getOrderPropertyForCol(colNum);
        return this.client.addComponent(componentClass, this.pagePath, idx, new int[0]);
    }

    public String getOrderPropertyForCol(int colNum) throws Exception {
        this.checkColNumExists(colNum);
        int lColNum = this.getLayoutColNum();
        if (colNum == lColNum) {
            return "before " + this.endColComponent.getName();
        }
        AbstractFoundationComponent colBreak = this.colBreaks[colNum - 1];
        return "before " + colBreak.getName();
    }

    public void setLayout(String layout) throws ClientException, InterruptedException {
        this.setProperty(PROP_LAYOUT, layout);
        this.save(new int[0]);
        int lColNum = this.getLayoutColNum();
        this.colBreaks = new AbstractFoundationComponent[lColNum];
        int idx = 0;
        for (AbstractFoundationComponent node = (AbstractFoundationComponent)this.getNext(); node != null && node.getResourceType().equals(RESOURCE_TYPE) && !node.getPropertyAsString(PROP_CONTROL_TYPE).equals(COL_END_CONTROL_TYPE); node = (AbstractFoundationComponent)node.getNext()) {
            if (!node.getResourceType().equals(RESOURCE_TYPE) || !node.getPropertyAsString(PROP_CONTROL_TYPE).equals(COL_BREAK_CONTROL_TYPE)) continue;
            this.colBreaks[idx] = node;
            ++idx;
        }
    }

    public AbstractFoundationComponent getColCtrlEndComponent() throws ClientException {
        return this.endColComponent;
    }

    public AbstractFoundationComponent[] getColCtrlBreaks() {
        return this.colBreaks;
    }

    private void checkColNumExists(int colNum) throws Exception {
        int lColNum = this.getLayoutColNum();
        if (colNum < 1 || colNum > lColNum) {
            throw new Exception("Column index out of range (must be between 1 AND LAYOUT_COL_NUMBER)");
        }
    }

    private int getLayoutColNum() {
        String layout = this.getPropertyAsString(PROP_LAYOUT);
        if (layout == null) {
            return 1;
        }
        return Integer.parseInt(layout.substring(0, 1));
    }
}

