/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.security;

import com.adobe.cq.testing.client.SecurityClient;
import com.adobe.cq.testing.client.security.AbstractAuthorizable;
import com.adobe.cq.testing.client.security.Authorizable;
import com.adobe.cq.testing.client.security.Group;
import com.adobe.cq.testing.client.security.User;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.URLParameterBuilder;
import org.codehaus.jackson.JsonNode;

public class AuthorizableManager {
    public static final String AUTHORIZABLE_POST_PATH = "/libs/granite/security/post/authorizables";
    public static final String AUTHORIZABLES_PATH = "/libs/granite/security/search/authorizables";
    public static final String AUTHORIZABLES = "authorizables";
    protected final SecurityClient client;

    public <T extends SecurityClient> AuthorizableManager(T client) {
        this.client = client;
    }

    public Group getGroupAdministrators() throws ClientException {
        return this.getGroup("administrators");
    }

    public Group getGroupContributor() throws ClientException {
        return this.getGroup("contributor");
    }

    public Group getGroupEveryone() throws ClientException {
        return this.getGroup("everyone");
    }

    public Group getGroupUserAdministrators() throws ClientException {
        return this.getGroup("user-administrators");
    }

    public User getUser(String userId) throws ClientException {
        return this.getAuthorizable(User.class, userId);
    }

    public Group getGroup(String groupId) throws ClientException {
        return this.getAuthorizable(Group.class, groupId);
    }

    public <T extends SecurityClient> Authorizable create(T client, Class<? extends AbstractAuthorizable> authorizableClass, String authorizableId, FormEntityBuilder formParameters, int ... expectedStatus) throws ClientException {
        if (formParameters == null) {
            throw new IllegalArgumentException("Parameters for creating an authorizable may not be null!");
        }
        client.doPost(AUTHORIZABLES_PATH, (HttpEntity)formParameters.build(), HttpUtils.getExpectedStatus((int)201, (int[])expectedStatus));
        return this.getAuthorizable(authorizableClass, authorizableId);
    }

    protected <T extends AbstractAuthorizable> T getAuthorizable(Class<T> authorizableClass, String authorizableId) throws ClientException {
        AbstractAuthorizable authorizable;
        try {
            Constructor<T> cons = authorizableClass.getConstructor(SecurityClient.class, String.class);
            authorizable = (AbstractAuthorizable)cons.newInstance(new Object[]{this.client, authorizableId});
        }
        catch (Exception e) {
            throw new ClientException("Could not initialize Authorizable: '" + authorizableClass.getCanonicalName() + "'.", (Throwable)e);
        }
        return (T)authorizable;
    }

    public List<Authorizable> getAuthorizables(String query) throws ClientException {
        JsonNode json = JsonUtils.getJsonNodeFromString((String)this.getAuthorizablesJson(query));
        JsonNode authorizablesNode = json.get(AUTHORIZABLES);
        ArrayList<Authorizable> authorizables = new ArrayList<Authorizable>();
        if (authorizablesNode.isArray()) {
            for (JsonNode authorizableNode : authorizablesNode) {
                String authorizableId = authorizableNode.get("authorizableId").getValueAsText();
                String type = authorizableNode.get("type").getValueAsText();
                AbstractAuthorizable authorizable = this.getAuthorizable(AbstractAuthorizable.getAuthorizableClass(type), authorizableId);
                authorizables.add(authorizable);
            }
        }
        return authorizables;
    }

    public String getAuthorizablesJson(String query) throws ClientException {
        URLParameterBuilder params = URLParameterBuilder.create().add("offset", "0").add("max", "-1").add("query", "{" + (query == null ? "" : query) + "}");
        return this.client.doGet("/libs/granite/security/search/authorizables.json", params.getList(), new int[]{200}).getContent();
    }

    public SlingHttpResponse doPost(FormEntityBuilder formParameters, int ... expectedStatus) throws ClientException {
        return this.client.doPost("/libs/granite/security/post/authorizables.html", (HttpEntity)formParameters.build(), expectedStatus);
    }
}

