/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.security;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.CQSecurityClient;
import com.adobe.cq.testing.client.security.Authorizable;
import com.adobe.cq.testing.client.security.Group;
import com.adobe.cq.testing.client.security.User;
import com.adobe.cq.testing.client.security.UserRule;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.apache.sling.testing.junit.rules.instance.Instance;
import org.junit.rules.ExternalResource;

public class CreateUserRule
extends ExternalResource
implements UserRule {
    private Instance instanceRule;
    private CQSecurityClient adminAuthor;
    private final String[] groups;
    private ThreadLocal<CQClient> userClient = new ThreadLocal();
    private ThreadLocal<User> user = new ThreadLocal();

    public CreateUserRule(Instance instanceRule, String ... groups) {
        this.instanceRule = instanceRule;
        this.groups = groups;
    }

    protected void before() throws Throwable {
        this.adminAuthor = (CQSecurityClient)this.instanceRule.getAdminClient(CQSecurityClient.class);
        String username = "testuser-" + UUID.randomUUID();
        String password = this.randomPass(30);
        new Polling(() -> {
            this.user.set(this.adminAuthor.createUser(username, password, (Group[])Arrays.stream(this.groups).map(this::getGroup).toArray(Group[]::new), new int[0]));
            return true;
        }).poll(10000L, 1000L);
        Thread.sleep(500L);
        new Polling(() -> this.user.get().exists()).poll(5000L, 500L);
        this.userClient.set(new CQClient(this.adminAuthor.getUrl(), username, password));
    }

    protected void after() {
        try {
            new Polling(() -> {
                this.adminAuthor.deleteAuthorizables(new Authorizable[]{this.user.get()}, new int[0]);
                return !this.user.get().exists();
            }).poll(5000L, 500L);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CQClient getClient() {
        return this.userClient.get();
    }

    public Supplier<SlingClient> getClientSupplier() {
        class ClientSupplier
        implements Supplier<SlingClient> {
            private final CreateUserRule userRule;

            public ClientSupplier(CreateUserRule userRule) {
                this.userRule = userRule;
            }

            @Override
            public SlingClient get() {
                return this.userRule.getClient();
            }
        }
        return new ClientSupplier(this);
    }

    private String randomPass(int length) {
        return new Random().ints(97, 123).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private Group getGroup(String groupName) {
        try {
            return new Group(this.adminAuthor, groupName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

