/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.security;

import com.adobe.cq.testing.client.SecurityClient;
import com.adobe.cq.testing.client.security.AbstractAuthorizable;
import com.adobe.cq.testing.client.security.Authorizable;
import com.adobe.cq.testing.client.security.GroupProfile;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;

public class Group
extends AbstractAuthorizable {
    public static final String ROOT_PATH = "/home/groups";
    protected GroupProfile profile;

    public <T extends SecurityClient> Group(T client, String authorizableId) throws ClientException, InterruptedException {
        super(client, authorizableId);
    }

    @Override
    public String getRootPath() {
        return ROOT_PATH;
    }

    public GroupProfile getGroupProfile() throws ClientException {
        if (this.profile == null) {
            this.initProfile();
        }
        return this.profile;
    }

    protected void initProfile() throws ClientException {
        this.profile = new GroupProfile(this);
    }

    public SlingHttpResponse addMembers(Authorizable[] authorizables, int ... expectedStatus) throws ClientException {
        if (authorizables == null) {
            throw new IllegalArgumentException("authorizables may not be null!");
        }
        FormEntityBuilder formEntry = FormEntityBuilder.create();
        formEntry.addParameter("_charset_", "utf-8");
        for (Authorizable authorizable : authorizables) {
            formEntry.addParameter("addMembers", Group.encodeURI(authorizable.getId()));
        }
        return this.doPost(formEntry, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse addMember(Authorizable authorizable, int ... expectedStatus) throws ClientException {
        Authorizable[] authorizables = new Authorizable[]{authorizable};
        return this.addMembers(authorizables, expectedStatus);
    }

    public SlingHttpResponse removeMembers(Authorizable[] authorizables, int ... expectedStatus) throws ClientException {
        if (authorizables == null) {
            throw new IllegalArgumentException("List of authorizables may not be null!");
        }
        FormEntityBuilder formEntry = FormEntityBuilder.create();
        formEntry.addParameter("_charset_", "utf-8");
        for (Authorizable authorizable : authorizables) {
            formEntry.addParameter("removeMembers", Group.encodeURI(authorizable.getId()));
        }
        return this.doPost(formEntry, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public boolean hasGroupMember(Authorizable authorizable) throws ClientException, InterruptedException {
        if (authorizable == null) {
            throw new IllegalArgumentException("Authorizable may not be null!");
        }
        return this.getMembers().containsKey(authorizable.getId());
    }

    public static <T extends SecurityClient> Group createGroup(T client, String groupId, String intermediatePath, String givenName, String aboutMe, int ... expectedStatus) throws ClientException, InterruptedException {
        if (client == null || groupId == null) {
            throw new IllegalArgumentException("Client and groupId may not be null!");
        }
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("_charset_", "utf-8").addParameter("createGroup", "2").addParameter("authorizableId", groupId);
        if (intermediatePath != null) {
            feb.addParameter("intermediatePath", intermediatePath);
        }
        if (givenName != null) {
            feb.addParameter("./profile/givenName", givenName);
        }
        if (aboutMe != null) {
            feb.addParameter("./profile/aboutMe", aboutMe);
        }
        client.getManager().doPost(feb, HttpUtils.getExpectedStatus((int)201, (int[])expectedStatus));
        return new Group(client, groupId);
    }
}

