/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.assertion;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.components.AbstractComponent;
import com.adobe.cq.testing.junit.assertion.GraniteAssert;
import com.adobe.cq.testing.util.TestUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.apache.sling.testing.clients.AbstractSlingClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.ResourceUtil;
import org.codehaus.jackson.JsonNode;
import org.junit.Assert;

public class ComponentAssert {
    public static void assertValidComponentNode(AbstractComponent comp) throws ClientException, InterruptedException {
        JsonNode componentNode = comp.getComponentNode();
        Assert.assertEquals((String)("'sling:resourceType' for '" + comp.getComponentPath() + "' not properly set!"), (Object)comp.getResourceType(), (Object)componentNode.get("sling:resourceType").getValueAsText());
    }

    public static void assertStringProperty(AbstractComponent comp, String value, String propName) {
        Assert.assertNotNull((String)(propName + " text has not been set!"), (Object)comp.getPropertyAsString(propName));
        Assert.assertEquals((String)(propName + " is wrong."), (Object)value, (Object)comp.getPropertyAsString(propName));
    }

    public static void assertUploadedImage(CQClient client, String imagePath, String resourcePath) throws ClientException, IOException {
        ComponentAssert.assertBinaryCompare(ResourceUtil.getResourceAsStream((String)resourcePath), client.doStreamGet(imagePath, null, null, new int[0]).getEntity().getContent());
    }

    public static void assertBinaryCompare(InputStream inStream1, InputStream inStream2) throws ClientException {
        Assert.assertTrue((String)"The Binaries are not the same", (boolean)TestUtil.binaryCompare(inStream1, inStream2));
    }

    public static void assertHasEditDialog(AbstractSlingClient client, String resourceType) throws ClientException {
        SlingHttpResponse exec = client.doGet("/libs/" + resourceType + "/dialog.infinity.json", new int[]{200});
        String dialogJson = exec.getContent();
        Pattern p = Pattern.compile("\"xtype\":\".*panel\"", 2);
        GraniteAssert.assertRegExFind("Can't call the edit dialog for component type " + resourceType, dialogJson, p);
    }
}

