/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.sling.testing.clients.ClientException;

public class TestUtil {
    public static final FastDateFormat ISO_DATETIME_TIME_ZONE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");

    public static Date parseJsonDateString(String dateString) throws ClientException {
        try {
            return new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z", Locale.ENGLISH).parse(dateString);
        }
        catch (ParseException e) {
            throw new ClientException("Couldn't parse date from string!", (Throwable)e);
        }
    }

    public static String getMD5Checksum(InputStream stream) {
        MessageDigest complete;
        byte[] buffer = new byte[1024];
        if (null == stream) {
            throw new IllegalArgumentException("Input stream can't be null!");
        }
        try {
            int numRead;
            complete = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = stream.read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            stream.close();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        byte[] b = complete.digest();
        String result = "";
        for (byte aB : b) {
            result = result + Integer.toString((aB & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static boolean binaryCompare(InputStream i1, InputStream i2) {
        try {
            if (i1 == null && i2 != null) {
                i2.close();
                throw new AssertionError((Object)"Input stream i1 must not be null for binary compare!");
            }
            if (i2 == null) {
                if (i1 != null) {
                    i1.close();
                }
                throw new AssertionError((Object)"Input stream i2 must not be null for binary compare!");
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Can't close Input stream!");
        }
        String md51 = TestUtil.getMD5Checksum(i1);
        String md52 = TestUtil.getMD5Checksum(i2);
        return md51.equals(md52);
    }

    public static String replaceSpecialCharsForRegexp(String regexp) {
        String spRegexp = regexp;
        spRegexp = spRegexp.replace("(", "\\(").replace(")", "\\)");
        spRegexp = spRegexp.replace("{", "\\{").replace("}", "\\}");
        spRegexp = spRegexp.replace(":", "\\:");
        return spRegexp;
    }
}

