/*
 * Decompiled with CFR 0.152.
 */
package com.airhacks.afterburner.injection;

import com.airhacks.afterburner.configuration.Configurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class Injector {
    private static final Map<Class, Object> modelsAndServices = new WeakHashMap<Class, Object>();
    private static final Set<Object> presenters = Collections.newSetFromMap(new WeakHashMap());
    private static Function<Class, Object> instanceSupplier = Injector.getDefaultInstanceSupplier();
    private static Consumer<String> LOG = Injector.getDefaultLogger();
    private static final Configurator configurator = new Configurator();

    public static Object instantiatePresenter(Class clazz, Function<String, Object> injectionContext) {
        Field[] fields;
        Object presenter = Injector.registerExistingAndInject(instanceSupplier.apply(clazz));
        for (Field field : fields = clazz.getDeclaredFields()) {
            String fieldName;
            Object value;
            if (!field.isAnnotationPresent(Inject.class) || (value = injectionContext.apply(fieldName = field.getName())) == null) continue;
            Injector.injectIntoField(field, presenter, value);
        }
        return presenter;
    }

    public static Object instantiatePresenter(Class clazz) {
        return Injector.instantiatePresenter(clazz, f -> null);
    }

    public static void setInstanceSupplier(Function<Class, Object> instanceSupplier) {
        Injector.instanceSupplier = instanceSupplier;
    }

    public static void setLogger(Consumer<String> logger) {
        LOG = logger;
    }

    public static void setConfigurationSource(Function<Object, Object> configurationSupplier) {
        configurator.set(configurationSupplier);
    }

    public static void resetInstanceSupplier() {
        instanceSupplier = Injector.getDefaultInstanceSupplier();
    }

    public static void resetConfigurationSource() {
        configurator.forgetAll();
    }

    public static Object registerExistingAndInject(Object instance) {
        Object product = Injector.injectAndInitialize(instance);
        presenters.add(product);
        return product;
    }

    public static <T> T instantiateModelOrService(Class<T> clazz) {
        Object product = modelsAndServices.get(clazz);
        if (product == null) {
            product = Injector.injectAndInitialize(instanceSupplier.apply(clazz));
            modelsAndServices.putIfAbsent(clazz, product);
        }
        return clazz.cast(product);
    }

    public static void setModelOrService(Class clazz, Object instance) {
        modelsAndServices.put(clazz, instance);
    }

    static Object injectAndInitialize(Object product) {
        Injector.injectMembers(product);
        Injector.initialize(product);
        return product;
    }

    static void injectMembers(Object instance) {
        Class<?> clazz = instance.getClass();
        Injector.injectMembers(clazz, instance);
    }

    public static void injectMembers(Class<? extends Object> clazz, Object instance) throws SecurityException {
        Field[] fields;
        LOG.accept("Injecting members for class " + clazz + " and instance " + instance);
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            LOG.accept("Field annotated with @Inject found: " + field);
            Class<?> type = field.getType();
            String key = field.getName();
            Object value = configurator.getProperty(clazz, key);
            LOG.accept("Value returned by configurator is: " + value);
            if (value == null && Injector.isNotPrimitiveOrString(type)) {
                LOG.accept("Field is not a JDK class");
                value = Injector.instantiateModelOrService(type);
            }
            if (value == null) continue;
            LOG.accept("Value is a primitive, injecting...");
            Injector.injectIntoField(field, instance, value);
        }
        Class<? extends Object> superclass = clazz.getSuperclass();
        if (superclass != null) {
            LOG.accept("Injecting members of: " + superclass);
            Injector.injectMembers(superclass, instance);
        }
    }

    static void injectIntoField(Field field, Object instance, Object target) {
        AccessController.doPrivileged(() -> {
            boolean wasAccessible = field.isAccessible();
            try {
                field.setAccessible(true);
                field.set(instance, target);
                Object var4_4 = null;
                return var4_4;
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new IllegalStateException("Cannot set field: " + field + " with value " + target, ex);
            }
            finally {
                field.setAccessible(wasAccessible);
            }
        });
    }

    static void initialize(Object instance) {
        Class<?> clazz = instance.getClass();
        Injector.invokeMethodWithAnnotation(clazz, instance, PostConstruct.class);
    }

    static void destroy(Object instance) {
        Class<?> clazz = instance.getClass();
        Injector.invokeMethodWithAnnotation(clazz, instance, PreDestroy.class);
    }

    static void invokeMethodWithAnnotation(Class clazz, Object instance, Class<? extends Annotation> annotationClass) throws IllegalStateException, SecurityException {
        Method[] declaredMethods;
        for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            AccessController.doPrivileged(() -> {
                boolean wasAccessible = method.isAccessible();
                try {
                    method.setAccessible(true);
                    Object object2 = method.invoke(instance, new Object[0]);
                    return object2;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    throw new IllegalStateException("Problem invoking " + annotationClass + " : " + method, ex);
                }
                finally {
                    method.setAccessible(wasAccessible);
                }
            });
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null) {
            Injector.invokeMethodWithAnnotation(superclass, instance, annotationClass);
        }
    }

    public static void forgetAll() {
        Collection<Object> values = modelsAndServices.values();
        values.stream().forEach(object -> Injector.destroy(object));
        presenters.stream().forEach(object -> Injector.destroy(object));
        presenters.clear();
        modelsAndServices.clear();
        Injector.resetInstanceSupplier();
        Injector.resetConfigurationSource();
    }

    static Function<Class, Object> getDefaultInstanceSupplier() {
        return c -> {
            try {
                return c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new IllegalStateException("Cannot instantiate view: " + c, ex);
            }
        };
    }

    public static Consumer<String> getDefaultLogger() {
        return l -> {};
    }

    private static boolean isNotPrimitiveOrString(Class<?> type) {
        return !type.isPrimitive() && !type.isAssignableFrom(String.class);
    }
}

