/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.APIClientConfiguration;
import com.algolia.search.http.AlgoliaHttpClient;
import com.algolia.search.http.AlgoliaHttpRequest;
import com.algolia.search.http.AlgoliaHttpResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.palominolabs.http.url.UrlBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;

class AppEngineHttpClient
extends AlgoliaHttpClient {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final ObjectMapper objectMapper;
    private final List<String> queryHosts;
    private final List<String> buildHosts;
    private final FetchOptions defaultFetchOptions;
    private final Map<String, String> headers;
    private final URLFetchService fetchService;
    private final int hostDownTimeout;

    AppEngineHttpClient(APIClientConfiguration configuration) {
        this.objectMapper = configuration.getObjectMapper();
        this.queryHosts = configuration.getQueryHosts();
        this.buildHosts = configuration.getBuildHosts();
        this.headers = configuration.getHeaders();
        this.hostDownTimeout = configuration.getHostDownTimeout();
        this.fetchService = URLFetchServiceFactory.getURLFetchService();
        this.defaultFetchOptions = FetchOptions.Builder.withDeadline((double)(configuration.getConnectTimeout() + configuration.getReadTimeout())).followRedirects().validateCertificate();
    }

    protected AlgoliaHttpResponse request(@Nonnull AlgoliaHttpRequest request) throws IOException {
        HTTPRequest httpRequest = this.build(request);
        HTTPResponse httpResponse = this.fetchService.fetch(httpRequest);
        return this.from(httpResponse);
    }

    private AlgoliaHttpResponse from(final HTTPResponse httpResponse) {
        return new AlgoliaHttpResponse(){

            public int getStatusCode() {
                return httpResponse.getResponseCode();
            }

            public Reader getBody() throws IOException {
                if (AppEngineHttpClient.this.hasGzip(httpResponse.getHeaders())) {
                    return new InputStreamReader((InputStream)new GZIPInputStream(new ByteArrayInputStream(httpResponse.getContent())), UTF8);
                }
                return new InputStreamReader((InputStream)new ByteArrayInputStream(httpResponse.getContent()), UTF8);
            }
        };
    }

    private boolean hasGzip(List<HTTPHeader> headers) {
        for (HTTPHeader header : headers) {
            if (!header.getName().equalsIgnoreCase("Content-Encoding") || !header.getValue().toLowerCase().contains("gzip")) continue;
            return true;
        }
        return false;
    }

    protected HTTPRequest build(AlgoliaHttpRequest request) throws MalformedURLException, CharacterCodingException {
        HTTPRequest httpRequest = new HTTPRequest(this.toUrl(request), HTTPMethod.valueOf((String)request.getMethod().name), this.defaultFetchOptions);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            httpRequest.addHeader(new HTTPHeader(entry.getKey(), entry.getValue()));
        }
        if (request.hasContent()) {
            httpRequest.setPayload(request.getContent().getBytes());
        }
        return httpRequest;
    }

    private URL toUrl(AlgoliaHttpRequest request) throws CharacterCodingException, MalformedURLException {
        UrlBuilder urlBuilder = UrlBuilder.forHost((String)"https", (String)request.getHost());
        for (String string : request.getPath()) {
            urlBuilder = urlBuilder.pathSegment(string);
        }
        for (Map.Entry entry : request.getParameters().entrySet()) {
            urlBuilder = urlBuilder.queryParam((String)entry.getKey(), (String)entry.getValue());
        }
        return new URL(urlBuilder.toUrlString());
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public List<String> getQueryHosts() {
        return this.queryHosts;
    }

    public List<String> getBuildHosts() {
        return this.buildHosts;
    }

    public int getHostDownTimeout() {
        return this.hostDownTimeout;
    }
}

