/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.AbstractIndex;
import com.algolia.search.AsyncAPIClient;
import com.algolia.search.inputs.BatchOperation;
import com.algolia.search.inputs.partial_update.PartialUpdateOperation;
import com.algolia.search.inputs.synonym.AbstractSynonym;
import com.algolia.search.objects.ApiKey;
import com.algolia.search.objects.IndexSettings;
import com.algolia.search.objects.Query;
import com.algolia.search.objects.SynonymQuery;
import com.algolia.search.objects.tasks.async.AsyncTask;
import com.algolia.search.objects.tasks.async.AsyncTaskIndexing;
import com.algolia.search.objects.tasks.async.AsyncTaskSingleIndex;
import com.algolia.search.responses.CreateUpdateKey;
import com.algolia.search.responses.DeleteKey;
import com.algolia.search.responses.SearchFacetResult;
import com.algolia.search.responses.SearchResult;
import com.algolia.search.responses.SearchSynonymResult;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class AsyncIndex<T>
extends AbstractIndex {
    private final String name;
    private final Class<T> klass;
    private final AsyncAPIClient client;

    AsyncIndex(String name, Class<T> klass, AsyncAPIClient client) {
        this.name = name;
        this.klass = klass;
        this.client = client;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getKlass() {
        return this.klass;
    }

    public CompletableFuture<AsyncTaskIndexing> addObject(@Nonnull T object) {
        return this.client.addObject(this.name, object);
    }

    public CompletableFuture<AsyncTaskIndexing> addObject(@Nonnull String objectID, @Nonnull T object) {
        return this.client.addObject(this.name, objectID, object);
    }

    public CompletableFuture<AsyncTaskSingleIndex> addObjects(@Nonnull List<T> objects) {
        return this.client.addObjects(this.name, objects);
    }

    public CompletableFuture<Optional<T>> getObject(@Nonnull String objectID) {
        return this.client.getObject(this.name, objectID, this.klass);
    }

    public CompletableFuture<List<T>> getObjects(@Nonnull List<String> objectIDs) {
        return this.client.getObjects(this.name, objectIDs, this.klass);
    }

    public CompletableFuture<List<T>> getObjects(@Nonnull List<String> objectIDs, @Nonnull List<String> attributesToRetrieve) {
        return this.client.getObjects(this.name, objectIDs, attributesToRetrieve, this.klass);
    }

    public void waitTask(@Nonnull AsyncTask task, long timeToWait) {
        Preconditions.checkArgument((timeToWait >= 0L ? 1 : 0) != 0, (String)"timeToWait must be >= 0, was %s", (Object[])new Object[]{timeToWait});
        this.client.waitTask(task, timeToWait);
    }

    public void waitTask(@Nonnull AsyncTask task) {
        this.client.waitTask(task, 100L);
    }

    public CompletableFuture<AsyncTask> delete() {
        return this.client.deleteIndex(this.name);
    }

    public CompletableFuture<AsyncTask> clear() {
        return this.client.clearIndex(this.name);
    }

    public CompletableFuture<AsyncTask> saveObject(@Nonnull String objectID, @Nonnull T object) {
        return this.client.saveObject(this.name, objectID, object);
    }

    public CompletableFuture<AsyncTaskSingleIndex> saveObjects(@Nonnull List<T> objects) {
        return this.client.saveObjects(this.name, objects);
    }

    public CompletableFuture<AsyncTask> deleteObject(@Nonnull String objectID) {
        return this.client.deleteObject(this.name, objectID);
    }

    public CompletableFuture<AsyncTaskSingleIndex> deleteObjects(@Nonnull List<String> objectIDs) {
        return this.client.deleteObjects(this.name, objectIDs);
    }

    public CompletableFuture<IndexSettings> getSettings() {
        return this.client.getSettings(this.name);
    }

    public CompletableFuture<AsyncTask> setSettings(@Nonnull IndexSettings settings) {
        return this.setSettings(settings, false);
    }

    public CompletableFuture<AsyncTask> setSettings(@Nonnull IndexSettings settings, @Nonnull Boolean forwardToReplicas) {
        return this.client.setSettings(this.name, settings, forwardToReplicas);
    }

    public CompletableFuture<List<ApiKey>> listKeys() {
        return this.client.listKeys(this.name);
    }

    public CompletableFuture<Optional<ApiKey>> getKey(@Nonnull String key) {
        return this.client.getKey(this.name, key);
    }

    public CompletableFuture<DeleteKey> deleteKey(@Nonnull String key) {
        return this.client.deleteKey(this.name, key);
    }

    public CompletableFuture<CreateUpdateKey> addKey(@Nonnull ApiKey key) {
        return this.client.addKey(this.name, key);
    }

    public CompletableFuture<CreateUpdateKey> updateKey(@Nonnull String keyName, @Nonnull ApiKey key) {
        return this.client.updateKey(this.name, keyName, key);
    }

    public CompletableFuture<AsyncTask> moveTo(@Nonnull String dstIndexName) {
        return this.client.moveIndex(this.name, dstIndexName);
    }

    public CompletableFuture<AsyncTask> copyTo(@Nonnull String dstIndexName) {
        return this.client.copyIndex(this.name, dstIndexName);
    }

    public CompletableFuture<SearchResult<T>> search(@Nonnull Query query) {
        return this.client.search(this.name, query, this.klass);
    }

    public CompletableFuture<SearchFacetResult> searchInFacetValues(@Nonnull String facetName, @Nonnull String facetQuery, Query query) {
        return this.client.searchFacet(this.name, facetName, facetQuery, query);
    }

    public CompletableFuture<SearchFacetResult> searchInFacetValues(@Nonnull String facetName, @Nonnull String facetQuery) {
        return this.searchInFacetValues(facetName, facetQuery, null);
    }

    @Deprecated
    public CompletableFuture<SearchFacetResult> searchFacet(@Nonnull String facetName, @Nonnull String facetQuery, Query query) {
        return this.searchInFacetValues(facetName, facetQuery, query);
    }

    @Deprecated
    public CompletableFuture<SearchFacetResult> searchFacet(@Nonnull String facetName, @Nonnull String facetQuery) {
        return this.searchInFacetValues(facetName, facetQuery);
    }

    public CompletableFuture<AsyncTaskSingleIndex> batch(@Nonnull List<BatchOperation> operations) {
        return this.client.batch(this.name, operations);
    }

    public CompletableFuture<AsyncTaskSingleIndex> partialUpdateObject(@Nonnull String objectID, @Nonnull Object object) {
        return this.client.partialUpdateObject(this.name, objectID, object);
    }

    public CompletableFuture<AsyncTaskSingleIndex> partialUpdateObjects(@Nonnull List<Object> objects) {
        return this.client.partialUpdateObjects(this.name, objects);
    }

    public CompletableFuture<AsyncTaskSingleIndex> partialUpdateObject(@Nonnull PartialUpdateOperation operation) {
        return this.partialUpdateObject(operation, true);
    }

    public CompletableFuture<AsyncTaskSingleIndex> partialUpdateObject(@Nonnull PartialUpdateOperation operation, boolean createIfNotExists) {
        return this.client.partialUpdateObject(this.name, operation, createIfNotExists);
    }

    public CompletableFuture<AsyncTask> saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content) {
        return this.saveSynonym(synonymID, content, false);
    }

    public CompletableFuture<AsyncTask> saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content, boolean forwardToReplicas) {
        return this.saveSynonym(synonymID, content, forwardToReplicas, false);
    }

    public CompletableFuture<AsyncTask> saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content, boolean forwardToReplicas, boolean replaceExistingSynonyms) {
        return this.client.saveSynonym(this.name, synonymID, content, forwardToReplicas, replaceExistingSynonyms);
    }

    public CompletableFuture<Optional<AbstractSynonym>> getSynonym(@Nonnull String synonymID) {
        return this.client.getSynonym(this.name, synonymID);
    }

    public CompletableFuture<AsyncTask> deleteSynonym(@Nonnull String synonymID) {
        return this.deleteSynonym(synonymID, false);
    }

    public CompletableFuture<AsyncTask> deleteSynonym(@Nonnull String synonymID, boolean forwardToReplicas) {
        return this.client.deleteSynonym(this.name, synonymID, forwardToReplicas);
    }

    public CompletableFuture<AsyncTask> clearSynonyms() {
        return this.clearSynonyms(false);
    }

    public CompletableFuture<AsyncTask> clearSynonyms(boolean forwardToReplicas) {
        return this.client.clearSynonyms(this.name, forwardToReplicas);
    }

    public CompletableFuture<SearchSynonymResult> searchSynonyms(@Nonnull SynonymQuery query) {
        return this.client.searchSynonyms(this.name, query);
    }

    public CompletableFuture<AsyncTask> batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas, boolean replaceExistingSynonyms) {
        return this.client.batchSynonyms(this.name, synonyms, forwardToReplicas, replaceExistingSynonyms);
    }

    public CompletableFuture<AsyncTask> batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas) {
        return this.batchSynonyms(synonyms, forwardToReplicas, false);
    }

    public CompletableFuture<AsyncTask> batchSynonyms(@Nonnull List<AbstractSynonym> synonyms) {
        return this.batchSynonyms(synonyms, false, false);
    }
}

