/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.Defaults;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.net.MediaType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;

public abstract class GenericAPIClientBuilder {
    protected final Random random = new Random();
    protected final String applicationId;
    protected final String apiKey;
    protected String customAgent;
    protected String customAgentVersion;
    protected Map<String, String> customHeaders = new HashMap<String, String>();
    protected int connectTimeout = 2000;
    protected int readTimeout = 2000;
    protected int hostDownTimeout = 300000;
    protected ObjectMapper objectMapper = Defaults.DEFAULT_OBJECT_MAPPER;

    public GenericAPIClientBuilder(@Nonnull String applicationId, @Nonnull String apiKey) {
        this.applicationId = applicationId;
        this.apiKey = apiKey;
    }

    public GenericAPIClientBuilder setUserAgent(@Nonnull String customAgent, @Nonnull String customAgentVersion) {
        this.customAgent = customAgent;
        this.customAgentVersion = customAgentVersion;
        return this;
    }

    public GenericAPIClientBuilder setExtraHeader(@Nonnull String key, String value) {
        this.customHeaders.put(key, value);
        return this;
    }

    public GenericAPIClientBuilder setConnectTimeout(int connectTimeout) {
        Preconditions.checkArgument((connectTimeout >= 0 ? 1 : 0) != 0, (String)"connectTimeout can not be < 0, but was %s", (Object[])new Object[]{connectTimeout});
        this.connectTimeout = connectTimeout;
        return this;
    }

    public GenericAPIClientBuilder setReadTimeout(int readTimeout) {
        Preconditions.checkArgument((readTimeout >= 0 ? 1 : 0) != 0, (String)"readTimeout can not be < 0, but was %s", (Object[])new Object[]{readTimeout});
        this.readTimeout = readTimeout;
        return this;
    }

    public GenericAPIClientBuilder setHostDownTimeout(int hostDownTimeout) {
        Preconditions.checkArgument((hostDownTimeout >= 0 ? 1 : 0) != 0, (String)"hostDownTimeout can not be < 0, but was %s", (Object[])new Object[]{hostDownTimeout});
        this.hostDownTimeout = hostDownTimeout;
        return this;
    }

    public GenericAPIClientBuilder setObjectMapper(@Nonnull ObjectMapper objectMapper) {
        this.objectMapper = objectMapper.copy().enable(new JsonGenerator.Feature[]{Defaults.OBJECT_MAPPER_DEFAULT_FEATURE}).disable(Defaults.OBJECT_MAPPER_DEFAULT_DESERIALIZATION_FEATURE);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getApiClientVersion() {
        try (InputStream versionStream = this.getClass().getResourceAsStream("/version.properties");){
            BufferedReader versionReader = new BufferedReader(new InputStreamReader(versionStream));
            String string = versionReader.readLine();
            return string;
        }
        catch (IOException iOException) {
            return "N/A";
        }
    }

    protected List<String> generateBuildHosts() {
        ArrayList hosts = Lists.newArrayList((Object[])new String[]{this.applicationId + "-1." + "algolianet.com", this.applicationId + "-2." + "algolianet.com", this.applicationId + "-3." + "algolianet.com"});
        Collections.shuffle(hosts, this.random);
        hosts.add(0, this.applicationId + "." + "algolia.net");
        return hosts;
    }

    protected List<String> generateQueryHosts() {
        ArrayList hosts = Lists.newArrayList((Object[])new String[]{this.applicationId + "-1." + "algolianet.com", this.applicationId + "-2." + "algolianet.com", this.applicationId + "-3." + "algolianet.com"});
        Collections.shuffle(hosts, this.random);
        hosts.add(0, this.applicationId + "-dsn." + "algolia.net");
        return hosts;
    }

    protected Map<String, String> generateHeaders() {
        String userAgent = String.format("Algolia for Java (%s); JVM (%s)", this.getApiClientVersion(), System.getProperty("java.version"));
        if (this.customAgent != null) {
            userAgent = userAgent + "; " + this.customAgent + " (" + this.customAgentVersion + ")";
        }
        return ImmutableMap.builder().put((Object)"Accept-Encoding", (Object)"gzip").put((Object)"Content-Type", (Object)MediaType.JSON_UTF_8.type()).put((Object)"User-Agent", (Object)userAgent).put((Object)"X-Algolia-Application-Id", (Object)this.applicationId).put((Object)"X-Algolia-API-Key", (Object)this.apiKey).putAll(this.customHeaders).build();
    }
}

