/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.expand.cli;

import com.alibaba.antx.expand.cli.CLIException;
import com.alibaba.antx.util.cli.CommandLine;
import com.alibaba.antx.util.cli.HelpFormatter;
import com.alibaba.antx.util.cli.OptionBuilder;
import com.alibaba.antx.util.cli.Options;
import com.alibaba.antx.util.cli.ParseException;
import com.alibaba.antx.util.cli.PosixParser;
import java.io.PrintWriter;

public class CLIManager {
    public static final String OPT_HELP = "h";
    public static final String OPT_VERBOSE = "v";
    public static final String OPT_CHARSET = "c";
    public static final String OPT_EXPAND_WAR = "w";
    public static final String OPT_EXPAND_RAR = "r";
    public static final String OPT_EXPAND_EJB_JAR = "e";
    public static final String OPT_OVERWRITE = "o";
    public static final String OPT_KEEP_REDUNDANT_FILES = "k";
    private Options options;

    public CLIManager() {
        OptionBuilder builder = new OptionBuilder();
        this.options = new Options();
        this.options.addOption(builder.withLongOpt("help").withDescription("\u663e\u793a\u5e2e\u52a9\u4fe1\u606f").create(OPT_HELP));
        this.options.addOption(builder.withLongOpt("verbose").withDescription("\u663e\u793a\u66f4\u591a\u4fe1\u606f").create(OPT_VERBOSE));
        this.options.addOption(builder.withLongOpt("charset").hasArg().withDescription("\u8f93\u5165/\u8f93\u51fa\u7f16\u7801\u5b57\u7b26\u96c6").create(OPT_CHARSET));
        this.options.addOption(builder.withLongOpt("expand-war").hasOptionalArg().withDescription("\u662f\u5426\u5c55\u5f00war\uff08yes|no\uff09\uff0c\u9ed8\u8ba4\u4e3ayes").create(OPT_EXPAND_WAR));
        this.options.addOption(builder.withLongOpt("expand-rar").hasOptionalArg().withDescription("\u662f\u5426\u5c55\u5f00rar\uff08yes|no\uff09\uff0c\u9ed8\u8ba4\u4e3ayes").create(OPT_EXPAND_RAR));
        this.options.addOption(builder.withLongOpt("expand-ejb-jar").hasOptionalArg().withDescription("\u662f\u5426\u5c55\u5f00ejb-jar\uff08yes|no\uff09\uff0c\u9ed8\u8ba4\u4e3ano").create(OPT_EXPAND_EJB_JAR));
        this.options.addOption(builder.withLongOpt("overwrite").hasOptionalArg().withDescription("\u5982\u679c\u76ee\u6807\u76ee\u5f55\u4e2d\u7684\u6587\u4ef6\u6bd4zip\u6587\u4ef6\u4e2d\u7684\u9879\u8981\u65b0\uff0c\u662f\u5426\u8986\u76d6\u4e4b\uff0c\u9ed8\u8ba4\u4e3ano").create(OPT_OVERWRITE));
        this.options.addOption(builder.withLongOpt("keep-redundant-files").hasOptionalArg().withDescription("\u5982\u679c\u76ee\u6807\u76ee\u5f55\u4e2d\u6709\u591a\u4f59\u7684\u6587\u4ef6\uff0c\u662f\u5426\u4fdd\u6301\u800c\u4e0d\u5220\u9664\uff0c\u9ed8\u8ba4\u4e3ano").create(OPT_KEEP_REDUNDANT_FILES));
    }

    public CommandLine parse(String[] args) {
        CommandLine cli;
        try {
            cli = new PosixParser().parse(this.options, args);
        }
        catch (ParseException e) {
            throw new CLIException(e);
        }
        return cli;
    }

    public void help(PrintWriter out) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.defaultSyntaxPrefix = "\u4f7f\u7528\u65b9\u6cd5\uff1a";
        formatter.printHelp(out, 74, "antxexpand [\u53ef\u9009\u53c2\u6570] \u6587\u4ef6\u540d [\u76ee\u6807\u76ee\u5f55]\n", "\u53ef\u9009\u53c2\u6570\uff1a", this.options, 1, 3, "\n");
    }
}

