/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.util;

import com.alibaba.antx.util.PatternSet;
import com.alibaba.antx.util.SelectorUtil;
import com.alibaba.antx.util.StringUtil;
import com.alibaba.antx.util.ZipUtil;
import com.alibaba.antx.util.scanner.DefaultScannerHandler;
import com.alibaba.antx.util.scanner.DirectoryScanner;
import com.alibaba.antx.util.scanner.ScannerException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class FileUtil {
    public static final String SYS_PROP_USER_HOME = "user.home";
    public static final String SYS_PROP_USER_CURRENT_DIR = "user.dir";
    public static final String[] DEFAULT_EXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.DS_Store"};
    private static final char COLON_CHAR = ':';
    private static final String UNC_PREFIX = "//";
    private static final String SLASH = "/";
    private static final String BACKSLASH = "\\";
    private static final char SLASH_CHAR = '/';
    private static final char BACKSLASH_CHAR = '\\';
    public static final String CURRENT_DIR = ".";
    public static final String UP_LEVEL_DIR = "..";

    public static File getUserHome() {
        return new File(System.getProperty(SYS_PROP_USER_HOME));
    }

    public static File getUserCurrentDir() {
        return new File(System.getProperty(SYS_PROP_USER_CURRENT_DIR));
    }

    public static File getFile(String basedir, String path) {
        return FileUtil.getFile(new File(basedir), path);
    }

    public static File getFile(File basedir, String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(basedir, path);
    }

    public static File find(String filename) {
        return FileUtil.find(FileUtil.getUserCurrentDir(), filename);
    }

    public static File find(File dir, String filename) {
        if (dir == null) {
            return null;
        }
        File file = new File(dir, filename);
        return file.exists() ? file : FileUtil.find(dir.getParentFile(), filename);
    }

    public static File getCanonicalFile(String filename) {
        if (StringUtil.isEmpty(filename)) {
            return null;
        }
        try {
            return new File(filename).getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean resourceAvailable(File base, String resourceId) {
        boolean available = false;
        if (base.exists()) {
            if (base.isDirectory()) {
                available = new File(base, resourceId).exists();
            } else {
                available = false;
                try {
                    String[] files = ZipUtil.getFileNamesInZipFile(base.toURI().toURL(), new String[]{resourceId}, null);
                    available = files != null && files.length > 0;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return available;
    }

    public static File[] getFilesInDirectory(File dir, String[] includes, String[] excludes) {
        String[] filenames = FileUtil.getFileNamesInDirectory(dir, includes, excludes);
        File[] files = new File[filenames.length];
        for (int i = 0; i < filenames.length; ++i) {
            files[i] = new File(dir, filenames[i]).getAbsoluteFile();
        }
        return files;
    }

    public static String[] getFileNamesInDirectory(File dir, String[] includes, String[] excludes) {
        final PatternSet patterns = new PatternSet(includes, excludes).addDefaultExcludes();
        final ArrayList files = new ArrayList();
        DirectoryScanner scanner = new DirectoryScanner(dir, new DefaultScannerHandler(){

            public boolean followUp() {
                String name = this.getScanner().getPath();
                return SelectorUtil.matchPathPrefix(name, patterns.getIncludes(), patterns.getExcludes());
            }

            public void file() throws ScannerException {
                String name = this.getScanner().getPath();
                if (SelectorUtil.matchPath(name, patterns.getIncludes(), patterns.getExcludes())) {
                    files.add(name);
                }
            }
        });
        scanner.scan();
        return files.toArray(new String[files.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String text) throws IOException {
        FileWriter out = null;
        try {
            out = new FileWriter(file);
            out.write(text);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void deleteDirectory(String directory) throws IOException {
        FileUtil.deleteDirectory(new File(directory));
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtil.cleanDirectory(directory);
        if (!directory.delete()) {
            String message = "Directory " + directory + " unable to be deleted.";
            throw new IOException(message);
        }
    }

    public static void cleanDirectory(String directory) throws IOException {
        FileUtil.cleanDirectory(new File(directory));
    }

    public static void cleanDirectory(File directory) throws IOException {
        File[] files;
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        IOException exception = null;
        for (File file : files = directory.listFiles()) {
            try {
                FileUtil.forceDelete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void forceDelete(String file) throws IOException {
        FileUtil.forceDelete(new File(file));
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtil.deleteDirectory(file);
        } else if (!file.delete()) {
            String message = "File " + file + " unable to be deleted.";
            throw new IOException(message);
        }
    }

    public static File normalizeFile(String path) {
        return FileUtil.normalizeFile(new File(path));
    }

    public static File normalizeFile(File file) {
        File basedir = file.getParentFile();
        String filename = file.getName();
        StringBuffer buffer = new StringBuffer(filename.length());
        char lastChar = '\u0000';
        for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            if (c == '_' || c == '-' || c == '.' || c == ',') {
                if (lastChar == '\u0000') continue;
                if (c != lastChar) {
                    buffer.append(c);
                }
                lastChar = c;
                continue;
            }
            buffer.append(c);
            lastChar = c;
        }
        for (int index = buffer.length() - 1; index > 0; --index) {
            char c;
            if (buffer.charAt(index) != '.') continue;
            for (int i = index - 1; i >= 0 && ((c = buffer.charAt(i)) == '_' || c == '-' || c == '.' || c == ','); --i) {
                buffer.deleteCharAt(i);
            }
        }
        return new File(basedir, buffer.toString()).getAbsoluteFile();
    }

    public static String normalizeAbsolutePath(String path) {
        Object normalizedPath = FileUtil.normalizePath(path, false);
        if (normalizedPath != null && !((String)normalizedPath).startsWith(SLASH)) {
            normalizedPath = ((String)normalizedPath).equals(CURRENT_DIR) || ((String)normalizedPath).equals("./") ? SLASH : (((String)normalizedPath).startsWith(UP_LEVEL_DIR) ? null : '/' + (String)normalizedPath);
        }
        return normalizedPath;
    }

    public static String normalizePath(String path) {
        return FileUtil.normalizePath(path, FileUtil.isWindows());
    }

    public static String normalizeWindowsPath(String path) {
        return FileUtil.normalizePath(path, true);
    }

    public static String normalizeUnixPath(String path) {
        return FileUtil.normalizePath(path, false);
    }

    private static String normalizePath(String path, boolean isWindows) {
        if (path == null) {
            return null;
        }
        path = path.trim();
        String prefix = FileUtil.getSystemDependentPrefix(path = path.replace('\\', '/'), isWindows);
        if (prefix == null) {
            return null;
        }
        path = path.substring(prefix.length());
        if (prefix.length() > 0 || path.startsWith(SLASH)) {
            prefix = prefix + '/';
        }
        boolean endsWithSlash = path.endsWith(SLASH);
        StringTokenizer tokenizer = new StringTokenizer(path, SLASH);
        StringBuffer buffer = new StringBuffer(prefix.length() + path.length());
        int level = 0;
        buffer.append(prefix);
        while (tokenizer.hasMoreTokens()) {
            String element = tokenizer.nextToken();
            if (CURRENT_DIR.equals(element)) continue;
            if (UP_LEVEL_DIR.equals(element)) {
                if (level == 0) {
                    if (prefix.length() > 0) {
                        return null;
                    }
                    buffer.append(UP_LEVEL_DIR).append('/');
                    continue;
                }
                --level;
                boolean found = false;
                for (int i = buffer.length() - 2; i >= prefix.length(); --i) {
                    if (buffer.charAt(i) != '/') continue;
                    buffer.setLength(i + 1);
                    found = true;
                    break;
                }
                if (found) continue;
                buffer.setLength(prefix.length());
                continue;
            }
            buffer.append(element).append('/');
            ++level;
        }
        if (buffer.length() == 0) {
            buffer.append(CURRENT_DIR).append('/');
        }
        if (!endsWithSlash && buffer.length() > prefix.length() && buffer.charAt(buffer.length() - 1) == '/') {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    private static String getSystemDependentPrefix(String path, boolean isWindows) {
        if (isWindows) {
            if (path.startsWith(UNC_PREFIX)) {
                if (path.length() == UNC_PREFIX.length()) {
                    return null;
                }
                int index = path.indexOf(SLASH, UNC_PREFIX.length());
                if (index != -1) {
                    return path.substring(0, index);
                }
                return path;
            }
            if (path.length() > 1 && path.charAt(1) == ':') {
                return path.substring(0, 2).toUpperCase();
            }
        }
        return "";
    }

    public static String getPathBasedOn(String basedir, String path) {
        return FileUtil.getPathBasedOn(basedir, path, FileUtil.isWindows());
    }

    public static String getWindowsPathBasedOn(String basedir, String path) {
        return FileUtil.getPathBasedOn(basedir, path, true);
    }

    public static String getUnixPathBasedOn(String basedir, String path) {
        return FileUtil.getPathBasedOn(basedir, path, false);
    }

    private static String getPathBasedOn(String basedir, String path, boolean isWindows) {
        if (path == null) {
            return null;
        }
        path = path.trim();
        String prefix = FileUtil.getSystemDependentPrefix(path = path.replace('\\', '/'), isWindows);
        if (prefix == null) {
            return null;
        }
        if (prefix.length() > 0 || path.length() > prefix.length() && path.charAt(prefix.length()) == '/') {
            return FileUtil.normalizePath(path, isWindows);
        }
        if (basedir == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(basedir.trim());
        if (basedir.length() > 0 && path.length() > 0 && basedir.charAt(basedir.length() - 1) != '/') {
            buffer.append('/');
        }
        buffer.append(path);
        return FileUtil.normalizePath(buffer.toString(), isWindows);
    }

    public static String getRelativePath(String basedir, String path) {
        return FileUtil.getRelativePath(basedir, path, FileUtil.isWindows());
    }

    public static String getWindowsRelativePath(String basedir, String path) {
        return FileUtil.getRelativePath(basedir, path, true);
    }

    public static String getUnixRelativePath(String basedir, String path) {
        return FileUtil.getRelativePath(basedir, path, false);
    }

    private static String getRelativePath(String basedir, String path, boolean isWindows) {
        int i;
        if ((basedir = FileUtil.normalizePath(basedir, isWindows)) == null) {
            return null;
        }
        String basePrefix = FileUtil.getSystemDependentPrefix(basedir, isWindows);
        if (basePrefix == null || basePrefix.length() == 0 && !basedir.startsWith(SLASH)) {
            return null;
        }
        if ((path = FileUtil.getPathBasedOn(basedir, path, isWindows)) == null) {
            return null;
        }
        String prefix = FileUtil.getSystemDependentPrefix(path, isWindows);
        if (!basePrefix.equals(prefix)) {
            return path;
        }
        boolean endsWithSlash = path.endsWith(SLASH);
        String[] baseParts = StringUtil.split(basedir.substring(basePrefix.length()), SLASH);
        String[] parts = StringUtil.split(path.substring(prefix.length()), SLASH);
        StringBuffer buffer = new StringBuffer();
        if (isWindows) {
            for (i = 0; i < baseParts.length && i < parts.length && baseParts[i].equalsIgnoreCase(parts[i]); ++i) {
            }
        } else {
            while (i < baseParts.length && i < parts.length && baseParts[i].equals(parts[i])) {
                ++i;
            }
        }
        if (i < baseParts.length && i < parts.length) {
            for (int j = i; j < baseParts.length; ++j) {
                buffer.append(UP_LEVEL_DIR).append('/');
            }
        }
        while (i < parts.length) {
            buffer.append(parts[i]);
            if (i < parts.length - 1) {
                buffer.append('/');
            }
            ++i;
        }
        if (buffer.length() == 0) {
            buffer.append(CURRENT_DIR);
        }
        String relpath = buffer.toString();
        if (endsWithSlash && !relpath.endsWith(SLASH)) {
            relpath = relpath + SLASH;
        }
        return relpath;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean isSymbolicLink(File parent, String name) throws IOException {
        File toTest;
        if (parent == null) {
            File f = new File(name);
            parent = f.getParentFile();
            name = f.getName();
        }
        return !(toTest = new File(parent.getCanonicalPath(), name)).getAbsolutePath().equals(toTest.getCanonicalPath());
    }
}

