/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.util;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class StringUtil {
    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty(Object str) {
        return StringUtil.isEmpty(StringUtil.toString(str));
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isBlank(Object str) {
        return StringUtil.isBlank(StringUtil.toString(str));
    }

    public static String getShortClassName(Class clazz) {
        return StringUtil.getShortClassName(clazz.getName());
    }

    public static String getShortClassName(String className) {
        int index = className.lastIndexOf(46);
        return className.substring(index + 1);
    }

    public static String[] split(String str) {
        return StringUtil.split(str, ",");
    }

    public static String join(Object[] array) {
        return StringUtil.join(array, ",");
    }

    public static String join(Object[] array, String separator) {
        int arraySize;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        int bufSize = (arraySize = array.length) == 0 ? 0 : arraySize * ((array[0] == null ? 16 : array[0].toString().length()) + (separator != null ? separator.length() : 0));
        StringBuffer buf = new StringBuffer(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (separator != null && i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String[] splitPath(String str) {
        return StringUtil.split(str, "," + File.pathSeparator);
    }

    public static String[] split(String str, String delimiters) {
        if (str == null || str.trim().length() == 0) {
            return new String[0];
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, delimiters);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String trimWhitespace(String str) {
        if (str == null) {
            return "";
        }
        return str.trim();
    }

    public static String deleteWhitespace(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String getValidIdentifier(String id) {
        return StringUtil.getValidIdentifier(id, null);
    }

    public static String getValidIdentifier(String id, String replaceInvalid) {
        if (replaceInvalid == null) {
            replaceInvalid = "_";
        }
        if (id == null || id.length() == 0) {
            return replaceInvalid;
        }
        boolean replaced = false;
        StringBuffer buffer = new StringBuffer(id.length());
        char c = id.charAt(0);
        if (Character.isJavaIdentifierStart(c)) {
            buffer.append(c);
        } else {
            buffer.append(replaceInvalid);
            replaced = true;
        }
        for (int i = 1; i < id.length(); ++i) {
            c = id.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                buffer.append(c);
                replaced = false;
                continue;
            }
            if (replaced) continue;
            replaced = true;
            buffer.append(replaceInvalid);
        }
        return buffer.toString();
    }

    public static String alignLeft(String str, int size) {
        return StringUtil.alignLeft(str, size, ' ');
    }

    public static String alignLeft(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        return StringUtil.alignLeft(str, size, String.valueOf(padChar));
    }

    public static String alignLeft(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (padStr == null || padStr.length() == 0) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    public static String alignRight(String str, int size) {
        return StringUtil.alignRight(str, size, ' ');
    }

    public static String alignRight(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        return StringUtil.alignRight(str, size, String.valueOf(padChar));
    }

    public static String alignRight(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (padStr == null || padStr.length() == 0) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static String center(String str, int size) {
        return StringUtil.center(str, size, ' ');
    }

    public static String center(String str, int size, char padChar) {
        if (str == null || size <= 0) {
            return str;
        }
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        str = StringUtil.alignRight(str, strLen + pads / 2, padChar);
        str = StringUtil.alignLeft(str, size, padChar);
        return str;
    }

    public static String center(String str, int size, String padStr) {
        int strLen;
        int pads;
        if (str == null || size <= 0) {
            return str;
        }
        if (padStr == null || padStr.length() == 0) {
            padStr = " ";
        }
        if ((pads = size - (strLen = str.length())) <= 0) {
            return str;
        }
        str = StringUtil.alignRight(str, strLen + pads / 2, padStr);
        str = StringUtil.alignLeft(str, size, padStr);
        return str;
    }

    public static String[] trimStringArray(String[] strs) {
        if (strs == null) {
            return new String[0];
        }
        ArrayList<String> strList = new ArrayList<String>(strs.length);
        for (String str2 : strs) {
            String str = StringUtil.trimWhitespace(str2);
            if (str.length() <= 0) continue;
            strList.add(str);
        }
        return strList.toArray(new String[strList.size()]);
    }

    public static String toString(Object obj) {
        return obj == null ? "" : obj.toString();
    }
}

