/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.typeconvert.converters;

import com.alibaba.toolkit.util.typeconvert.ConvertChain;
import com.alibaba.toolkit.util.typeconvert.ConvertFailedException;
import com.alibaba.toolkit.util.typeconvert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigIntegerConverter
implements Converter {
    protected static final BigInteger DEFAULT_VALUE = BigInteger.ZERO;

    public Object convert(Object value, ConvertChain chain) {
        if (value == null) {
            throw new ConvertFailedException().setDefaultValue(DEFAULT_VALUE);
        }
        if (value instanceof BigInteger) {
            return value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (value instanceof Number) {
            return new BigDecimal(value.toString()).toBigInteger();
        }
        if (value instanceof String) {
            String strValue = ((String)value).trim();
            try {
                return new BigInteger(strValue);
            }
            catch (NumberFormatException e) {
                if (strValue.length() > 0) {
                    throw new ConvertFailedException(e);
                }
                throw new ConvertFailedException().setDefaultValue(DEFAULT_VALUE);
            }
        }
        return chain.convert(value);
    }
}

