/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.discovery.registry;

import com.alibaba.fescar.common.util.NetUtil;
import com.alibaba.fescar.config.Configuration;
import com.alibaba.fescar.config.ConfigurationFactory;
import com.alibaba.fescar.discovery.registry.RegistryService;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.ZkClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperRegisterServiceImpl
implements RegistryService<IZkChildListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperRegisterServiceImpl.class);
    private static volatile ZookeeperRegisterServiceImpl instance;
    private static volatile ZkClient zkClient;
    private static final Configuration FILE_CONFIG;
    private static final String ZK_PATH_SPLIT_CHAR = "/";
    private static final String FILE_ROOT_REGISTRY = "registry";
    private static final String FILE_CONFIG_SPLIT_CHAR = ".";
    private static final String REGISTRY_CLUSTER = "cluster";
    private static final String REGISTRY_TYPE = "zk";
    private static final String SERVER_ADDR_KEY = "serverAddr";
    private static final String SESSION_TIME_OUT_KEY = "session.timeout";
    private static final String CONNECT_TIME_OUT_KEY = "connect.timeout";
    private static final String FILE_CONFIG_KEY_PREFIX = "registry.zk.";
    private static final String ROOT_PATH = "/registry/zk/";
    private static final String ROOT_PATH_WITHOUT_SUFFIX = "/registry/zk";
    private static final ConcurrentMap<String, List<InetSocketAddress>> CLUSTER_ADDRESS_MAP;
    private static final ConcurrentMap<String, List<IZkChildListener>> LISTENER_SERVICE_MAP;

    private ZookeeperRegisterServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ZookeeperRegisterServiceImpl getInstance() {
        if (null != instance) return instance;
        Class<ZookeeperRegisterServiceImpl> clazz = ZookeeperRegisterServiceImpl.class;
        synchronized (ZookeeperRegisterServiceImpl.class) {
            if (null != instance) return instance;
            instance = new ZookeeperRegisterServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void register(InetSocketAddress address) throws Exception {
        NetUtil.validAddress((InetSocketAddress)address);
        String path = this.getRegisterPathByPath(address);
        this.getClientInstance().createPersistent(path, true);
    }

    @Override
    public void unregister(InetSocketAddress address) throws Exception {
        NetUtil.validAddress((InetSocketAddress)address);
        String path = this.getRegisterPathByPath(address);
        this.getClientInstance().delete(path);
    }

    @Override
    public void subscribe(String cluster, IZkChildListener listener) throws Exception {
        if (null == cluster) {
            return;
        }
        String path = ROOT_PATH + cluster;
        if (this.getClientInstance().exists(path)) {
            this.getClientInstance().subscribeChildChanges(path, listener);
            LISTENER_SERVICE_MAP.putIfAbsent(cluster, new ArrayList());
            ((List)LISTENER_SERVICE_MAP.get(cluster)).add(listener);
        }
    }

    @Override
    public void unsubscribe(String cluster, IZkChildListener listener) throws Exception {
        if (null == cluster) {
            return;
        }
        String path = ROOT_PATH + cluster;
        if (this.getClientInstance().exists(path)) {
            this.getClientInstance().unsubscribeChildChanges(path, listener);
            List subscribeList = (List)LISTENER_SERVICE_MAP.get(cluster);
            if (null != subscribeList) {
                ArrayList<IZkChildListener> newSubscribeList = new ArrayList<IZkChildListener>();
                for (IZkChildListener eventListener : subscribeList) {
                    if (eventListener.equals(listener)) continue;
                    newSubscribeList.add(eventListener);
                }
                LISTENER_SERVICE_MAP.put(cluster, newSubscribeList);
            }
        }
    }

    @Override
    public List<InetSocketAddress> lookup(String key) throws Exception {
        String clusterName = this.getServiceGroup(key);
        if (null == clusterName) {
            return null;
        }
        Boolean exist = this.getClientInstance().exists(ROOT_PATH + clusterName);
        if (!exist.booleanValue()) {
            return null;
        }
        if (!LISTENER_SERVICE_MAP.containsKey(clusterName)) {
            List childClusterPath = this.getClientInstance().getChildren(ROOT_PATH + clusterName);
            this.refreshClusterAddressMap(clusterName, childClusterPath);
            this.subscribeCluster(clusterName);
        }
        return (List)CLUSTER_ADDRESS_MAP.get(clusterName);
    }

    private ZkClient getClientInstance() {
        if (zkClient == null && !(zkClient = new ZkClient(FILE_CONFIG.getConfig("registry.zk.serverAddr"), FILE_CONFIG.getInt("registry.zk.session.timeout"), FILE_CONFIG.getInt("registry.zk.connect.timeout"))).exists(ROOT_PATH_WITHOUT_SUFFIX)) {
            zkClient.createPersistent(ROOT_PATH_WITHOUT_SUFFIX, true);
        }
        return zkClient;
    }

    private void subscribeCluster(String clusterName) throws Exception {
        this.subscribe(clusterName, new IZkChildListener(){

            public void handleChildChange(String parentPath, List<String> currentChilds) throws Exception {
                String clusterName = parentPath.replace(ZookeeperRegisterServiceImpl.ROOT_PATH, "");
                if (CollectionUtils.isEmpty(currentChilds) && CLUSTER_ADDRESS_MAP.get(clusterName) != null) {
                    CLUSTER_ADDRESS_MAP.remove(clusterName);
                } else if (!CollectionUtils.isEmpty(currentChilds)) {
                    ZookeeperRegisterServiceImpl.this.refreshClusterAddressMap(clusterName, currentChilds);
                }
            }
        });
    }

    private void refreshClusterAddressMap(String clusterName, List<String> instances) {
        ArrayList<InetSocketAddress> newAddressList = new ArrayList<InetSocketAddress>();
        if (instances == null) {
            CLUSTER_ADDRESS_MAP.put(clusterName, newAddressList);
            return;
        }
        for (String path : instances) {
            try {
                String[] ipAndPort = path.split(":");
                newAddressList.add(new InetSocketAddress(ipAndPort[0], Integer.parseInt(ipAndPort[1])));
            }
            catch (Exception e) {
                LOGGER.warn("The cluster instance info is error, instance info:{}", (Object)path);
            }
        }
        CLUSTER_ADDRESS_MAP.put(clusterName, newAddressList);
    }

    private String getClusterName() {
        String clusterConfigName = "registry.zk.cluster";
        return FILE_CONFIG.getConfig(clusterConfigName);
    }

    private String getServiceGroup(String key) {
        Configuration configuration = ConfigurationFactory.getInstance();
        String clusterNameKey = "service.vgroup_mapping." + key;
        return configuration.getConfig(clusterNameKey);
    }

    private String getRegisterPathByPath(InetSocketAddress address) {
        return ROOT_PATH + this.getClusterName() + ZK_PATH_SPLIT_CHAR + NetUtil.toStringAddress((InetSocketAddress)address);
    }

    static {
        FILE_CONFIG = ConfigurationFactory.FILE_INSTANCE;
        CLUSTER_ADDRESS_MAP = new ConcurrentHashMap<String, List<InetSocketAddress>>();
        LISTENER_SERVICE_MAP = new ConcurrentHashMap<String, List<IZkChildListener>>();
    }
}

