/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.discovery.registry;

import com.alibaba.fescar.common.exception.EurekaRegistryException;
import com.alibaba.fescar.common.util.NetUtil;
import com.alibaba.fescar.config.Configuration;
import com.alibaba.fescar.config.ConfigurationFactory;
import com.alibaba.fescar.discovery.registry.CustomEurekaInstanceConfig;
import com.alibaba.fescar.discovery.registry.RegistryService;
import com.google.common.collect.Lists;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.config.ConfigurationManager;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.EurekaEvent;
import com.netflix.discovery.EurekaEventListener;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaRegistryServiceImpl
implements RegistryService<EurekaEventListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EurekaRegistryServiceImpl.class);
    private static final String DEFAULT_APPLICATION = "default";
    private static final String PRO_SERVICE_URL_KEY = "serviceUrl";
    private static final String FILE_ROOT_REGISTRY = "registry";
    private static final String FILE_CONFIG_SPLIT_CHAR = ".";
    private static final String REGISTRY_TYPE = "eureka";
    private static final String CLUSTER = "application";
    private static final String REGISTRY_WEIGHT = "weight";
    private static final String EUREKA_CONFIG_SERVER_URL_KEY = "eureka.serviceUrl.default";
    private static final String EUREKA_CONFIG_REFRESH_KEY = "eureka.client.refresh.interval";
    private static final String EUREKA_CONFIG_SHOULD_REGISTER = "eureka.registration.enabled";
    private static final String EUREKA_CONFIG_METADATA_WEIGHT = "eureka.metadata.weight";
    private static final int EUREKA_REFRESH_INTERVAL = 5;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private static final String DEFAULT_WEIGHT = "1";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.FILE_INSTANCE;
    private static ConcurrentMap<String, Set<InetSocketAddress>> clusterAddressMap;
    private static volatile boolean subscribeListener;
    private static volatile ApplicationInfoManager applicationInfoManager;
    private static volatile CustomEurekaInstanceConfig instanceConfig;
    private static volatile EurekaRegistryServiceImpl instance;
    private static volatile EurekaClient eurekaClient;

    private EurekaRegistryServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EurekaRegistryServiceImpl getInstance() {
        if (null != instance) return instance;
        Class<EurekaRegistryServiceImpl> clazz = EurekaRegistryServiceImpl.class;
        synchronized (EurekaRegistryServiceImpl.class) {
            if (null != instance) return instance;
            clusterAddressMap = new ConcurrentHashMap<String, Set<InetSocketAddress>>(8);
            instanceConfig = new CustomEurekaInstanceConfig();
            instance = new EurekaRegistryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void register(InetSocketAddress address) throws Exception {
        NetUtil.validAddress((InetSocketAddress)address);
        instanceConfig.setIpAddress(address.getAddress().getHostAddress());
        instanceConfig.setPort(address.getPort());
        instanceConfig.setApplicationName(this.getApplicationName());
        instanceConfig.setInstanceId(this.getInstanceId());
        this.getEurekaClient(true);
        applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.UP);
    }

    @Override
    public void unregister(InetSocketAddress address) throws Exception {
        if (eurekaClient == null) {
            return;
        }
        applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.DOWN);
    }

    @Override
    public void subscribe(String cluster, EurekaEventListener listener) throws Exception {
        subscribeListener = true;
        this.getEurekaClient(false).registerEventListener(listener);
    }

    @Override
    public void unsubscribe(String cluster, EurekaEventListener listener) throws Exception {
        subscribeListener = false;
        this.getEurekaClient(false).unregisterEventListener(listener);
    }

    @Override
    public List<InetSocketAddress> lookup(String key) throws Exception {
        Configuration config = ConfigurationFactory.getInstance();
        String clusterName = config.getConfig("service.vgroup_mapping." + key);
        if (null == clusterName) {
            return null;
        }
        if (!subscribeListener) {
            this.refreshCluster();
            this.subscribe((String)null, new EurekaEventListener(){

                public void onEvent(EurekaEvent event) {
                    try {
                        EurekaRegistryServiceImpl.this.refreshCluster();
                    }
                    catch (Exception e) {
                        LOGGER.error("Eureka event listener refreshCluster error!");
                    }
                }
            });
        }
        return Lists.newArrayList((Iterable)((Iterable)clusterAddressMap.get(clusterName.toUpperCase())));
    }

    @Override
    public void close() throws Exception {
        if (eurekaClient != null) {
            eurekaClient.shutdown();
        }
        this.clean();
    }

    private void refreshCluster() throws EurekaRegistryException {
        Applications applications = this.getEurekaClient(false).getApplications();
        List list = applications.getRegisteredApplications();
        if (list == null || list.isEmpty()) {
            clusterAddressMap.clear();
            return;
        }
        for (Application app : list) {
            HashSet<InetSocketAddress> addressSet = new HashSet<InetSocketAddress>();
            List instances = app.getInstances();
            if (instances == null || instances.isEmpty()) break;
            for (InstanceInfo instance : instances) {
                addressSet.add(new InetSocketAddress(instance.getIPAddr(), instance.getPort()));
            }
            clusterAddressMap.put(app.getName(), addressSet);
        }
    }

    private Properties getEurekaProperties(boolean needRegister) {
        Properties eurekaProperties = new Properties();
        eurekaProperties.setProperty(EUREKA_CONFIG_REFRESH_KEY, String.valueOf(5));
        String url = FILE_CONFIG.getConfig(this.getEurekaServerUrlFileKey());
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new EurekaRegistryException("eureka server url can not be null!");
        }
        eurekaProperties.setProperty(EUREKA_CONFIG_SERVER_URL_KEY, url);
        String weight = FILE_CONFIG.getConfig(this.getEurekaInstanceWeightFileKey());
        if (StringUtils.isNotBlank((CharSequence)weight)) {
            eurekaProperties.setProperty(EUREKA_CONFIG_METADATA_WEIGHT, weight);
        } else {
            eurekaProperties.setProperty(EUREKA_CONFIG_METADATA_WEIGHT, DEFAULT_WEIGHT);
        }
        if (!needRegister) {
            eurekaProperties.setProperty(EUREKA_CONFIG_SHOULD_REGISTER, "false");
        }
        return eurekaProperties;
    }

    private String getApplicationName() {
        String application = FILE_CONFIG.getConfig(this.getEurekaApplicationFileKey());
        if (null == application) {
            application = DEFAULT_APPLICATION;
        }
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EurekaClient getEurekaClient(boolean needRegister) throws EurekaRegistryException {
        if (eurekaClient != null) return eurekaClient;
        Class<EurekaRegistryServiceImpl> clazz = EurekaRegistryServiceImpl.class;
        synchronized (EurekaRegistryServiceImpl.class) {
            try {
                if (!needRegister) {
                    instanceConfig = new CustomEurekaInstanceConfig();
                }
                ConfigurationManager.loadProperties((Properties)this.getEurekaProperties(needRegister));
                InstanceInfo instanceInfo = new EurekaConfigBasedInstanceInfoProvider((EurekaInstanceConfig)instanceConfig).get();
                applicationInfoManager = new ApplicationInfoManager((EurekaInstanceConfig)instanceConfig, instanceInfo);
                eurekaClient = new DiscoveryClient(applicationInfoManager, (EurekaClientConfig)new DefaultEurekaClientConfig());
            }
            catch (Exception e) {
                this.clean();
                throw new EurekaRegistryException("register eureka is error!", (Throwable)e);
            }
            return eurekaClient;
        }
    }

    private void clean() {
        eurekaClient = null;
        applicationInfoManager = null;
        instanceConfig = null;
    }

    private String getInstanceId() {
        return String.format("%s:%s:%d", instanceConfig.getAppname(), instanceConfig.getIpAddress(), instanceConfig.getNonSecurePort());
    }

    private String getEurekaServerUrlFileKey() {
        return "registry.eureka.serviceUrl";
    }

    private String getEurekaApplicationFileKey() {
        return "registry.eureka.application";
    }

    private String getEurekaInstanceWeightFileKey() {
        return "registry.eureka.weight";
    }

    static {
        subscribeListener = false;
    }
}

