/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.discovery.registry.consul;

import com.alibaba.fescar.common.thread.NamedThreadFactory;
import com.alibaba.fescar.common.util.NetUtil;
import com.alibaba.fescar.config.Configuration;
import com.alibaba.fescar.config.ConfigurationFactory;
import com.alibaba.fescar.discovery.registry.RegistryService;
import com.alibaba.fescar.discovery.registry.consul.ConsulListener;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.health.HealthServicesRequest;
import com.ecwid.consul.v1.health.model.HealthService;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class ConsulRegistryServiceImpl
implements RegistryService<ConsulListener> {
    private static volatile ConsulRegistryServiceImpl instance;
    private static volatile ConsulClient client;
    private static final Configuration FILE_CONFIG;
    private static final String FILE_ROOT_REGISTRY = "registry";
    private static final String FILE_CONFIG_SPLIT_CHAR = ".";
    private static final String REGISTRY_TYPE = "consul";
    private static final String SERVER_ADDR_KEY = "serverAddr";
    private static final String REGISTRY_CLUSTER = "cluster";
    private static final String DEFAULT_CLUSTER_NAME = "default";
    private static final String SERVICE_TAG = "fescar";
    private static final String FILE_CONFIG_KEY_PREFIX = "registry.consul.";
    private static ConcurrentMap<String, List<InetSocketAddress>> clusterAddressMap;
    private static ConcurrentMap<String, Set<ConsulListener>> listenerMap;
    private static ExecutorService notifierExecutor;
    private static ConcurrentMap<String, ConsulNotifier> notifiers;
    private static final int THREAD_POOL_NUM = 1;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private static final String DEFAULT_CHECK_INTERVAL = "10s";
    private static final String DEFAULT_CHECK_TIMEOUT = "1s";
    private static final String DEFAULT_DEREGISTER_TIME = "20s";
    private static final int DEFAULT_WATCH_TIMEOUT = 60;

    private ConsulRegistryServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConsulRegistryServiceImpl getInstance() {
        if (null != instance) return instance;
        Class<ConsulRegistryServiceImpl> clazz = ConsulRegistryServiceImpl.class;
        synchronized (ConsulRegistryServiceImpl.class) {
            if (null != instance) return instance;
            clusterAddressMap = new ConcurrentHashMap<String, List<InetSocketAddress>>(8);
            listenerMap = new ConcurrentHashMap<String, Set<ConsulListener>>(8);
            notifiers = new ConcurrentHashMap<String, ConsulNotifier>(8);
            notifierExecutor = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("fescar-consul-notifier", 1));
            instance = new ConsulRegistryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void register(InetSocketAddress address) throws Exception {
        NetUtil.validAddress((InetSocketAddress)address);
        this.getConsulClient().agentServiceRegister(this.createService(address));
    }

    @Override
    public void unregister(InetSocketAddress address) throws Exception {
        NetUtil.validAddress((InetSocketAddress)address);
        this.getConsulClient().agentServiceDeregister(this.createServiceId(address));
    }

    @Override
    public void subscribe(String cluster, ConsulListener listener) throws Exception {
        listenerMap.putIfAbsent(cluster, new HashSet());
        ((Set)listenerMap.get(cluster)).add(listener);
        Response<List<HealthService>> response = this.getHealthyServices(cluster, -1L, 60L);
        Long index = response.getConsulIndex();
        ConsulNotifier notifier = notifiers.computeIfAbsent(cluster, k -> new ConsulNotifier(cluster, index));
        notifierExecutor.submit(notifier);
    }

    @Override
    public void unsubscribe(String cluster, ConsulListener listener) throws Exception {
        ConsulNotifier notifier = (ConsulNotifier)notifiers.remove(cluster);
        notifier.stop();
    }

    @Override
    public List<InetSocketAddress> lookup(String key) throws Exception {
        String cluster = this.getServiceGroup(key);
        if (null == cluster) {
            return null;
        }
        if (!listenerMap.containsKey(cluster)) {
            this.refreshCluster(cluster);
            this.subscribe(cluster, (List<HealthService> services) -> this.refreshCluster(cluster, services));
        }
        return (List)clusterAddressMap.get(cluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ConsulClient getConsulClient() {
        if (null != client) return client;
        Class<ConsulRegistryServiceImpl> clazz = ConsulRegistryServiceImpl.class;
        synchronized (ConsulRegistryServiceImpl.class) {
            if (null != client) return client;
            client = new ConsulClient(FILE_CONFIG.getConfig("registry.consul.serverAddr"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return client;
        }
    }

    private String getClusterName() {
        String clusterConfigName = "registry.consul.cluster";
        return FILE_CONFIG.getConfig(clusterConfigName, DEFAULT_CLUSTER_NAME);
    }

    private String createServiceId(InetSocketAddress address) {
        return this.getClusterName() + "-" + NetUtil.toStringAddress((InetSocketAddress)address);
    }

    private NewService createService(InetSocketAddress address) {
        NewService newService = new NewService();
        newService.setId(this.createServiceId(address));
        newService.setName(this.getClusterName());
        newService.setTags(Collections.singletonList(SERVICE_TAG));
        newService.setPort(Integer.valueOf(address.getPort()));
        newService.setAddress(NetUtil.toIpAddress((SocketAddress)address));
        newService.setCheck(this.createCheck(address));
        return newService;
    }

    private NewService.Check createCheck(InetSocketAddress address) {
        NewService.Check check = new NewService.Check();
        check.setTcp(NetUtil.toStringAddress((InetSocketAddress)address));
        check.setInterval(DEFAULT_CHECK_INTERVAL);
        check.setTimeout(DEFAULT_CHECK_TIMEOUT);
        check.setDeregisterCriticalServiceAfter(DEFAULT_DEREGISTER_TIME);
        return check;
    }

    private Response<List<HealthService>> getHealthyServices(String service, long index, long watchTimeout) {
        return this.getConsulClient().getHealthServices(service, HealthServicesRequest.newBuilder().setTag(SERVICE_TAG).setQueryParams(new QueryParams(watchTimeout, index)).setPassing(true).build());
    }

    private String getServiceGroup(String key) {
        String clusterNameKey = "service.vgroup_mapping." + key;
        return ConfigurationFactory.getInstance().getConfig(clusterNameKey);
    }

    private void refreshCluster(String cluster) {
        if (null == cluster) {
            return;
        }
        Response<List<HealthService>> response = this.getHealthyServices(this.getClusterName(), -1L, -1L);
        if (response == null) {
            return;
        }
        this.refreshCluster(cluster, (List)response.getValue());
    }

    private void refreshCluster(String cluster, List<HealthService> services) {
        if (null == cluster || services == null) {
            return;
        }
        clusterAddressMap.put(cluster, services.stream().map(HealthService::getService).map(service -> new InetSocketAddress(service.getAddress(), (int)service.getPort())).collect(Collectors.toList()));
    }

    @Override
    public void close() throws Exception {
        client = null;
    }

    static {
        FILE_CONFIG = ConfigurationFactory.FILE_INSTANCE;
        clusterAddressMap = null;
        listenerMap = null;
        notifierExecutor = null;
        notifiers = null;
    }

    private class ConsulNotifier
    implements Runnable {
        private String cluster;
        private long consulIndex;
        private boolean running;

        ConsulNotifier(String cluster, long consulIndex) {
            this.cluster = cluster;
            this.consulIndex = consulIndex;
            this.running = true;
        }

        @Override
        public void run() {
            while (this.running) {
                this.processService();
            }
        }

        private void processService() {
            Response response = ConsulRegistryServiceImpl.this.getHealthyServices(this.cluster, this.consulIndex, 60L);
            Long currentIndex = response.getConsulIndex();
            if (currentIndex != null && currentIndex > this.consulIndex) {
                List services = (List)response.getValue();
                this.consulIndex = currentIndex;
                for (ConsulListener listener : (Set)listenerMap.get(this.cluster)) {
                    listener.onEvent(services);
                }
            }
        }

        void stop() {
            this.running = false;
        }
    }
}

