/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseUEConnection;
import com.alibaba.hbase.client.ElementConvertor;
import com.alibaba.lindorm.client.AdminService;
import com.alibaba.lindorm.client.SystemService;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.LindormFamilyAttributes;
import com.alibaba.lindorm.client.schema.LindormTableDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.security.SecurityCapability;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class AliHBaseUEAdmin
implements Admin {
    private AdminService adminService;
    private AliHBaseUEConnection connection;
    private int operationTimeout;
    private Configuration conf;
    private SystemService systemService;

    public AliHBaseUEAdmin(AliHBaseUEConnection connection) throws IOException {
        this.connection = connection;
        this.conf = connection.getConfiguration();
        this.operationTimeout = connection.getOperationTimeout();
        this.adminService = connection.getAdminService();
        this.systemService = connection.getSystemService();
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public void abort(String why, Throwable e) {
    }

    public boolean isAborted() {
        return false;
    }

    public void close() throws IOException {
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public boolean tableExists(TableName tableName) throws IOException {
        return this.connection.getWideColumnService(tableName.getNamespaceAsString()).listTables().contains(tableName.getQualifierAsString());
    }

    public boolean tableExists(byte[] tableName) throws IOException {
        return this.tableExists(TableName.valueOf((byte[])tableName));
    }

    public boolean tableExists(String tableName) throws IOException {
        return this.tableExists(TableName.valueOf((String)tableName));
    }

    public Connection getConnection() {
        return this.connection;
    }

    public HTableDescriptor[] listTables() throws IOException {
        TableName[] tableNames = this.listTableNames();
        HTableDescriptor[] tableDescriptors = new HTableDescriptor[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            tableDescriptors[i] = this.getTableDescriptor(tableNames[i]);
        }
        return tableDescriptors;
    }

    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        return this.listTables();
    }

    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables();
    }

    public HTableDescriptor[] listTables(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTables();
    }

    public HTableDescriptor[] listTables(String regex, boolean includeSysTables) throws IOException {
        return this.listTables();
    }

    public TableName[] listTableNames() throws IOException {
        List<String> tables = this.adminService.listTableNamesByPrefix("");
        TableName[] tableNames = new TableName[tables.size()];
        for (int i = 0; i < tables.size(); ++i) {
            tableNames[i] = ElementConvertor.toHBaseTableName(tables.get(i));
        }
        return tableNames;
    }

    public TableName[] listTableNames(Pattern pattern) throws IOException {
        return this.listTableNames();
    }

    public TableName[] listTableNames(String regex) throws IOException {
        return this.listTableNames();
    }

    public TableName[] listTableNames(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTableNames();
    }

    public TableName[] listTableNames(String regex, boolean includeSysTables) throws IOException {
        return this.listTableNames();
    }

    public HTableDescriptor getTableDescriptor(TableName tableName) throws TableNotFoundException, IOException {
        LindormTableDescriptor lindormTableDescriptor = this.connection.getWideColumnService(tableName.getNamespaceAsString()).describeTable(tableName.getQualifierAsString());
        return ElementConvertor.toHbaseTableDescriptor(tableName.getNamespaceAsString(), lindormTableDescriptor);
    }

    public HTableDescriptor[] listTableDescriptorsByNamespace(String name) throws IOException {
        TableName[] tableNames = this.listTableNamesByNamespace(name);
        HTableDescriptor[] hTableDescriptors = new HTableDescriptor[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            hTableDescriptors[i] = this.getTableDescriptor(tableNames[i]);
        }
        return hTableDescriptors;
    }

    public HTableDescriptor[] getTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        HTableDescriptor[] tableDescriptors = new HTableDescriptor[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tableDescriptors[i] = this.getTableDescriptor(tableNames.get(i));
        }
        return tableDescriptors;
    }

    public List<HTableDescriptor> listTableDescriptors(List<TableName> tableNames) throws IOException {
        ArrayList<HTableDescriptor> tableDescriptors = new ArrayList<HTableDescriptor>();
        for (TableName tableName : tableNames) {
            tableDescriptors.add(this.getTableDescriptor(tableName));
        }
        return tableDescriptors;
    }

    public HTableDescriptor[] getTableDescriptors(List<String> names) throws IOException {
        ArrayList<TableName> tableNames = new ArrayList<TableName>();
        for (String name : names) {
            tableNames.add(TableName.valueOf((String)name));
        }
        return this.getTableDescriptorsByTableName(tableNames);
    }

    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        List<String> tables = this.connection.getWideColumnService(name).listTables();
        TableName[] tableNames = new TableName[tables.size()];
        for (int i = 0; i < tables.size(); ++i) {
            tableNames[i] = TableName.valueOf((String)name, (String)tables.get(i));
        }
        return tableNames;
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            this.createTable(desc, new byte[][]{startKey, endKey});
            return;
        }
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    public void createTable(HTableDescriptor hTableDescriptor, byte[][] bytes) throws IOException {
        LindormTableDescriptor lindormTableDescriptor = ElementConvertor.toLindormTableDescripter(hTableDescriptor, false);
        TableName tableName = hTableDescriptor.getTableName();
        this.connection.getWideColumnService(tableName.getNamespaceAsString()).createTable(lindormTableDescriptor, bytes);
    }

    public void deleteTable(TableName tableName) throws IOException {
        this.connection.getWideColumnService(tableName.getNamespaceAsString()).deleteTable(tableName.getQualifierAsString());
    }

    public void deleteTable(String tableName) throws IOException {
        this.deleteTable(TableName.valueOf((String)tableName));
    }

    public void deleteTable(byte[] tableName) throws IOException {
        this.deleteTable(TableName.valueOf((byte[])tableName));
    }

    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        this.connection.getWideColumnService(tableName.getNamespaceAsString()).truncateTable(tableName.getQualifierAsString());
    }

    public void enableTable(TableName tableName) throws IOException {
        this.connection.getWideColumnService(tableName.getNamespaceAsString()).onlineTable(tableName.getQualifierAsString());
    }

    public void enableTable(byte[] tableName) throws IOException {
        this.enableTable(TableName.valueOf((byte[])tableName));
    }

    public void enableTable(String tableName) throws IOException {
        this.enableTable(TableName.valueOf((String)tableName));
    }

    public void disableTable(TableName tableName) throws IOException {
        this.connection.getWideColumnService(tableName.getNamespaceAsString()).offlineTable(tableName.getQualifierAsString());
    }

    public void disableTable(byte[] tableName) throws IOException {
        this.disableTable(TableName.valueOf((byte[])tableName));
    }

    public void disableTable(String tableName) throws IOException {
        this.disableTable(TableName.valueOf((String)tableName));
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        return this.connection.getWideColumnService(tableName.getNamespaceAsString()).isTableOnline(tableName.getQualifierAsString());
    }

    public boolean isTableEnabled(byte[] tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableEnabled(String tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf((String)tableName));
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.connection.getWideColumnService(tableName.getNamespaceAsString()).isTableOffline(tableName.getQualifierAsString());
    }

    public boolean isTableDisabled(byte[] tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableDisabled(String tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf((String)tableName));
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.isTableEnabled(tableName);
    }

    public boolean isTableAvailable(byte[] tableName) throws IOException {
        return this.isTableAvailable(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        return this.isTableAvailable(TableName.valueOf((String)tableName));
    }

    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        throw new UnsupportedOperationException("isTableAvailable with split keys is not supported");
    }

    public void addColumn(TableName tableName, HColumnDescriptor columnFamily) throws IOException {
        this.connection.getWideColumnService(tableName.getNamespaceAsString()).addFamily(tableName.getQualifierAsString(), ElementConvertor.toLindormcolumnFamilyDescriptor(columnFamily, false));
    }

    public void addColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(TableName.valueOf((byte[])tableName), column);
    }

    public void addColumn(String tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(TableName.valueOf((String)tableName), column);
    }

    public void deleteColumn(TableName tableName, byte[] columnFamily) throws IOException {
        this.connection.getWideColumnService(tableName.getNamespaceAsString()).deleteFamily(tableName.getQualifierAsString(), Bytes.toString((byte[])columnFamily));
    }

    public void deleteColumn(byte[] tableName, String columnName) throws IOException {
        this.deleteColumn(TableName.valueOf((byte[])tableName), Bytes.toBytes((String)columnName));
    }

    public void deleteColumn(String tableName, String columnName) throws IOException {
        this.deleteColumn(TableName.valueOf((String)tableName), Bytes.toBytes((String)columnName));
    }

    public void modifyColumn(TableName tableName, HColumnDescriptor columnFamily) throws IOException {
        List<LindormFamilyAttributes> lindormFamilyAttributes = ElementConvertor.toLindormFamilyAttributes(columnFamily, false);
        this.connection.getWideColumnService(tableName.getNamespaceAsString()).modifyFamilyAttributes(tableName.getQualifierAsString(), lindormFamilyAttributes);
    }

    public void modifyColumn(String tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(TableName.valueOf((String)tableName), descriptor);
    }

    public void modifyColumn(byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(TableName.valueOf((byte[])tableName), descriptor);
    }

    public void modifyTable(TableName tableName, HTableDescriptor td) throws IOException {
        this.modifyTable(td);
    }

    public void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        this.modifyTable(TableName.valueOf((byte[])tableName), htd);
    }

    public void modifyTable(String tableName, HTableDescriptor htd) throws IOException {
        this.modifyTable(TableName.valueOf((String)tableName), htd);
    }

    public void modifyTable(HTableDescriptor td) throws IOException {
        LindormTableDescriptor lindormTableDescriptor = ElementConvertor.toLindormTableDescripter(td, false);
        this.connection.getWideColumnService(td.getTableName().getNamespaceAsString()).modifyTableAttributes(lindormTableDescriptor);
    }

    public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
        throw new UnsupportedOperationException("modifyNamespace is not supported");
    }

    public void deleteNamespace(String name) throws IOException {
        this.adminService.removeNamespace(name);
    }

    public NamespaceDescriptor getNamespaceDescriptor(String name) throws NamespaceNotFoundException, IOException {
        if (this.adminService.listNamespaces().contains(name)) {
            return NamespaceDescriptor.create((String)name).build();
        }
        throw new NamespaceNotFoundException(name + " is not found");
    }

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        List<String> namespaces = this.adminService.listNamespaces();
        NamespaceDescriptor[] namespaceDescriptors = new NamespaceDescriptor[namespaces.size()];
        for (int i = 0; i < namespaces.size(); ++i) {
            namespaceDescriptors[i] = NamespaceDescriptor.create((String)namespaces.get(i)).build();
        }
        return namespaceDescriptors;
    }

    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        this.adminService.createNamespace(descriptor.getName());
    }

    public void flush(TableName tableName) {
        for (String idc : this.systemService.getLConnection().getAllIDC()) {
            try {
                this.systemService.flush(ElementConvertor.toLindormTableFullName(tableName), idc);
            }
            catch (LindormException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public void flush(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.flush(Bytes.toBytes((String)tableNameOrRegionName));
    }

    public void flush(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        try {
            this.flushRegion(tableNameOrRegionName);
        }
        catch (IllegalArgumentException var3) {
            this.flush(TableName.valueOf((byte[])tableNameOrRegionName));
        }
    }

    public void flushRegion(byte[] regionName) {
        String idcName = this.systemService.getLConnection().getAllIDC().get(0);
        try {
            this.systemService.flush(Bytes.toString((byte[])regionName), idcName);
        }
        catch (LindormException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void compact(TableName tableName) {
        for (String idc : this.systemService.getLConnection().getAllIDC()) {
            try {
                this.systemService.compact(ElementConvertor.toLindormTableFullName(tableName), idc);
            }
            catch (LindormException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public void compact(String tableNameOrRegionName) throws IOException {
        this.compact(Bytes.toBytes((String)tableNameOrRegionName));
    }

    public void compactRegion(byte[] regionName) {
        String idcName = this.systemService.getLConnection().getAllIDC().get(0);
        try {
            this.systemService.compact(Bytes.toString((byte[])regionName), idcName);
        }
        catch (LindormException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void compact(TableName tableName, byte[] columnFamily) {
        this.compact(tableName);
    }

    public void compact(byte[] tableNameOrRegionName) throws IOException {
        try {
            this.compactRegion(tableNameOrRegionName);
        }
        catch (IllegalArgumentException var3) {
            this.compact(TableName.valueOf((byte[])tableNameOrRegionName));
        }
    }

    public void compact(String tableOrRegionName, String columnFamily) throws IOException {
        this.compact(Bytes.toBytes((String)tableOrRegionName), Bytes.toBytes((String)columnFamily));
    }

    public void compact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException {
        try {
            this.compactRegion(tableNameOrRegionName);
        }
        catch (IllegalArgumentException var4) {
            this.compact(TableName.valueOf((byte[])tableNameOrRegionName));
        }
    }

    public void compactRegion(byte[] regionName, byte[] columnFamily) {
        this.compactRegion(regionName);
    }

    public void majorCompact(TableName tableName) {
        for (String idc : this.systemService.getLConnection().getAllIDC()) {
            try {
                this.systemService.majorCompact(ElementConvertor.toLindormTableFullName(tableName), idc);
            }
            catch (LindormException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public void majorCompactRegion(byte[] regionName) {
        String idcName = this.systemService.getLConnection().getAllIDC().get(0);
        try {
            this.systemService.majorCompact(Bytes.toString((byte[])regionName), idcName);
        }
        catch (LindormException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void majorCompact(String tableNameOrRegionName, String columnFamily) throws IOException {
        this.majorCompact(Bytes.toBytes((String)tableNameOrRegionName), Bytes.toBytes((String)columnFamily));
    }

    public void majorCompact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException {
        try {
            this.majorCompactRegion(tableNameOrRegionName, columnFamily);
        }
        catch (IllegalArgumentException var4) {
            this.majorCompact(TableName.valueOf((byte[])tableNameOrRegionName), columnFamily);
        }
    }

    public void majorCompact(TableName tableName, byte[] columnFamily) {
        this.majorCompact(tableName);
    }

    public void majorCompact(String tableNameOrRegionName) throws IOException {
        this.majorCompact(Bytes.toBytes((String)tableNameOrRegionName));
    }

    public void majorCompact(byte[] tableNameOrRegionName) throws IOException {
        try {
            this.majorCompactRegion(tableNameOrRegionName);
        }
        catch (IllegalArgumentException var3) {
            this.majorCompact(TableName.valueOf((byte[])tableNameOrRegionName));
        }
    }

    public void majorCompactRegion(byte[] regionName, byte[] columnFamily) {
        this.majorCompactRegion(regionName);
    }

    public boolean switchRpcThrottle(boolean enable) throws IOException {
        throw new UnsupportedOperationException("switchRpcThrottle is not supported");
    }

    public boolean isRpcThrottleEnabled() throws IOException {
        throw new UnsupportedOperationException("isRpcThrottleEnabled is not supported");
    }

    public boolean exceedThrottleQuotaSwitch(boolean enable) throws IOException {
        throw new UnsupportedOperationException("exceedThrottleQuotaSwitch is not supported");
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        throw new UnsupportedOperationException("disableTables is not supported");
    }

    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("disableTables by pattern not supported");
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        throw new UnsupportedOperationException("enableTables by pattern not supported");
    }

    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("enableTables by pattern not supported");
    }

    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        throw new UnsupportedOperationException("deleteTables by pattern not supported");
    }

    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("deleteTables by pattern not supported");
    }

    public void closeRegion(String regionname, String serverName) {
        throw new UnsupportedOperationException("closeRegion not supported");
    }

    public void closeRegion(byte[] regionname, String serverName) {
        throw new UnsupportedOperationException("closeRegion not supported");
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) {
        throw new UnsupportedOperationException("closeRegionWithEncodedRegionName not supported");
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) {
        throw new UnsupportedOperationException("closeRegion not supported");
    }

    public List<HRegionInfo> getOnlineRegions(ServerName sn) {
        throw new UnsupportedOperationException("getOnlineRegions not supported");
    }

    public List<HRegionInfo> getRegions(ServerName serverName) {
        throw new UnsupportedOperationException("getRegions not supported");
    }

    public Map<ServerName, Boolean> compactionSwitch(boolean switchState, List<String> serverNamesList) {
        throw new UnsupportedOperationException("compactionSwitch not supported");
    }

    public void move(byte[] encodedRegionName) {
        throw new UnsupportedOperationException("move not supported");
    }

    public void move(byte[] encodedRegionName, ServerName destServerName) {
        throw new UnsupportedOperationException("move not supported");
    }

    public void assign(byte[] regionName) {
        throw new UnsupportedOperationException("assign not supported");
    }

    public void unassign(byte[] regionName, boolean force) {
        throw new UnsupportedOperationException("unassign not supported");
    }

    public void offline(byte[] regionName) {
        throw new UnsupportedOperationException("offline not supported");
    }

    public boolean isBalancerEnabled() {
        throw new UnsupportedOperationException("isBalancerEnabled not supported");
    }

    public boolean normalize() {
        throw new UnsupportedOperationException("normalize not supported");
    }

    public boolean isNormalizerEnabled() {
        throw new UnsupportedOperationException("isNormalizerEnabled not supported");
    }

    public boolean isCatalogJanitorEnabled() {
        throw new UnsupportedOperationException("isCatalogJanitorEnabled not supported");
    }

    public boolean runCleanerChore() {
        throw new UnsupportedOperationException("runCleanerChore not supported");
    }

    public boolean isCleanerChoreEnabled() {
        throw new UnsupportedOperationException("isCleanerChoreEnabled not supported");
    }

    public void mergeRegions(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) {
        throw new UnsupportedOperationException("mergeRegions not supported");
    }

    public void split(TableName tableName) {
        throw new UnsupportedOperationException("split not supported");
    }

    public void splitRegion(byte[] regionName) {
        throw new UnsupportedOperationException("splitRegion not supported");
    }

    public void split(TableName tableName, byte[] splitPoint) {
        throw new UnsupportedOperationException("split not supported");
    }

    public void splitRegion(byte[] regionName, byte[] splitPoint) {
        throw new UnsupportedOperationException("splitRegion not supported");
    }

    public void shutdown() {
        throw new UnsupportedOperationException("shutdown not supported");
    }

    public void stopMaster() {
        throw new UnsupportedOperationException("stopMaster not supported");
    }

    public boolean isMasterInMaintenanceMode() {
        throw new UnsupportedOperationException("isMasterInMaintenanceMode not supported");
    }

    public void stopRegionServer(String hostnamePort) {
        throw new UnsupportedOperationException("stopRegionServer not supported");
    }

    public List<HRegionInfo> getTableRegions(TableName tableName) {
        throw new UnsupportedOperationException("getTableRegions not supported");
    }

    public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("abortProcedure not supported");
    }

    public Future<Boolean> abortProcedureAsync(long procId, boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("abortProcedureAsync not supported");
    }

    public void rollWALWriter(ServerName serverName) {
        throw new UnsupportedOperationException("rollWALWriter not supported");
    }

    public long getLastMajorCompactionTimestamp(TableName tableName) {
        throw new UnsupportedOperationException("getLastMajorCompactionTimestamp not supported");
    }

    public long getLastMajorCompactionTimestampForRegion(byte[] regionName) {
        throw new UnsupportedOperationException("getLastMajorCompactionTimestampForRegion not supported");
    }

    public void snapshot(String snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(byte[] snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void restoreSnapshot(byte[] snapshotName) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void restoreSnapshot(String snapshotName) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot, boolean restoreAcl) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void cloneSnapshot(byte[] snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("cloneSnapshot not supported");
    }

    public void cloneSnapshot(String snapshotName, TableName tableName, boolean restoreAcl) {
        throw new UnsupportedOperationException("cloneSnapshot not supported");
    }

    public void cloneSnapshot(String snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("cloneSnapshot not supported");
    }

    public void execProcedure(String signature, String instance, Map<String, String> props) {
        throw new UnsupportedOperationException("execProcedure not supported");
    }

    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) {
        throw new UnsupportedOperationException("isProcedureFinished not supported");
    }

    public void deleteSnapshot(byte[] snapshotName) {
        throw new UnsupportedOperationException("deleteSnapshot not supported");
    }

    public void deleteSnapshot(String snapshotName) {
        throw new UnsupportedOperationException("deleteSnapshot not supported");
    }

    public void deleteSnapshots(String regex) {
        throw new UnsupportedOperationException("deleteSnapshots not supported");
    }

    public void deleteSnapshots(Pattern pattern) {
        throw new UnsupportedOperationException("deleteSnapshots not supported");
    }

    public void deleteTableSnapshots(String tableNameRegex, String snapshotNameRegex) {
        throw new UnsupportedOperationException("deleteTableSnapshots not supported");
    }

    public void deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) {
        throw new UnsupportedOperationException("deleteTableSnapshots not supported");
    }

    public void setQuota(QuotaSettings quota) {
        throw new UnsupportedOperationException("setQuota not supported");
    }

    public QuotaRetriever getQuotaRetriever(QuotaFilter filter) {
        throw new UnsupportedOperationException("getQuotaRetriever not supported");
    }

    public CoprocessorRpcChannel coprocessorService() {
        throw new UnsupportedOperationException("coprocessorService not supported");
    }

    public CoprocessorRpcChannel coprocessorService(ServerName serverName) {
        throw new UnsupportedOperationException("coprocessorService not supported");
    }

    public void updateConfiguration(ServerName server) {
        throw new UnsupportedOperationException("updateConfiguration not supported");
    }

    public void updateConfiguration() {
        throw new UnsupportedOperationException("updateConfiguration not supported");
    }

    public List<SecurityCapability> getSecurityCapabilities() {
        throw new UnsupportedOperationException("getSecurityCapabilities not supported");
    }

    public List<ServerName> clearDeadServers(List<ServerName> servers) {
        throw new UnsupportedOperationException("clearDeadServers not supported");
    }

    public void move(byte[] bytes, byte[] bytes1) throws IOException {
        throw new UnsupportedOperationException("move not supported");
    }

    public void createTableAsync(HTableDescriptor hTableDescriptor, byte[][] bytes) throws IOException {
        throw new UnsupportedOperationException("createTableAsync not supported");
    }

    public void enableTableAsync(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("enableTableAsync not supported");
    }

    public void disableTableAsync(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("disableTableAsync not supported");
    }

    public Pair<Integer, Integer> getAlterStatus(TableName tableName) throws IOException {
        return new Pair((Object)0, (Object)1);
    }

    public Pair<Integer, Integer> getAlterStatus(byte[] bytes) throws IOException {
        return new Pair((Object)0, (Object)1);
    }

    public void compactRegionServer(ServerName serverName, boolean b) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("compactRegionServer not supported");
    }

    public boolean setBalancerRunning(boolean b, boolean b1) throws IOException {
        throw new UnsupportedOperationException("setBalancerRunning not supported");
    }

    public boolean balancer() throws IOException {
        throw new UnsupportedOperationException("balancer not supported");
    }

    public boolean balancer(boolean b) throws IOException {
        throw new UnsupportedOperationException("balancer not supported");
    }

    public boolean setNormalizerRunning(boolean b) throws IOException {
        throw new UnsupportedOperationException("setNormalizerRunning not supported");
    }

    public boolean enableCatalogJanitor(boolean b) throws IOException {
        throw new UnsupportedOperationException("enableCatalogJanitor not supported");
    }

    public int runCatalogScan() throws IOException {
        throw new UnsupportedOperationException("runCatalogScan not supported");
    }

    public boolean setCleanerChoreRunning(boolean b) throws IOException {
        throw new UnsupportedOperationException("setCleanerChoreRunning not supported");
    }

    public ClusterStatus getClusterStatus() throws IOException {
        throw new UnsupportedOperationException("getClusterStatus not supported");
    }

    public ProcedureInfo[] listProcedures() throws IOException {
        throw new UnsupportedOperationException("listProcedures not supported");
    }

    public String[] getMasterCoprocessors() throws IOException {
        throw new UnsupportedOperationException("getMasterCoprocessors not supported");
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("getCompactionState not supported");
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionStateForRegion(byte[] bytes) throws IOException {
        throw new UnsupportedOperationException("getCompactionStateForRegion not supported");
    }

    public void snapshot(String s, TableName tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(HBaseProtos.SnapshotDescription snapshotDescription) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public MasterProtos.SnapshotResponse takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshotDescription) throws IOException, SnapshotCreationException {
        throw new UnsupportedOperationException("takeSnapshotAsync not supported");
    }

    public boolean isSnapshotFinished(HBaseProtos.SnapshotDescription snapshotDescription) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        throw new UnsupportedOperationException("isSnapshotFinished not supported");
    }

    public byte[] execProcedureWithRet(String s, String s1, Map<String, String> map) throws IOException {
        throw new UnsupportedOperationException("execProcedureWithRet not supported");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
        throw new UnsupportedOperationException("listSnapshots not supported");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(String s) throws IOException {
        throw new UnsupportedOperationException("listSnapshots not supported");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("listSnapshots not supported");
    }

    public List<HBaseProtos.SnapshotDescription> listTableSnapshots(String s, String s1) throws IOException {
        throw new UnsupportedOperationException("listTableSnapshots not supported");
    }

    public List<HBaseProtos.SnapshotDescription> listTableSnapshots(Pattern pattern, Pattern pattern1) throws IOException {
        throw new UnsupportedOperationException("listTableSnapshots not supported");
    }

    public int getMasterInfoPort() throws IOException {
        throw new UnsupportedOperationException("getMasterInfoPort not supported");
    }

    public List<ServerName> listDeadServers() throws IOException {
        throw new UnsupportedOperationException("listDeadServers not supported");
    }
}

