/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core;

import com.alibaba.lindorm.client.ExporterService;
import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.core.AsyncDDLType;
import com.alibaba.lindorm.client.core.LindormBasicService;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.exporter.ExporterConsumer;
import com.alibaba.lindorm.client.exporter.ExporterLogFile;
import com.alibaba.lindorm.client.exporter.FileSystemInfo;
import com.alibaba.lindorm.client.exporter.LindormIdc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class LindormExporterService
extends LindormBasicService
implements ExporterService {
    private static final int millisInSeconds = 1000;
    private static AtomicInteger exporterServiceCount = new AtomicInteger(0);

    public LindormExporterService(LindormClientConfig config) throws LindormException {
        super(config, "ExporterService" + exporterServiceCount.getAndIncrement());
    }

    public LindormExporterService(LindormClientConfig config, String serviceName) throws LindormException {
        super(config, serviceName);
    }

    @Override
    public ExporterConsumer registerLogConsumer(String consumerId, String consumerName) throws IOException {
        ExporterConsumer consumer = new ExporterConsumer(consumerId, consumerName);
        this.registerLogConsumerAsync(null, consumer);
        return consumer;
    }

    @Override
    public ExporterConsumer registerLogConsumer(String userName, String consumerId, String consumerName) throws IOException {
        ExporterConsumer consumer = new ExporterConsumer(consumerId, consumerName);
        this.registerLogConsumerAsync(userName, consumer);
        return consumer;
    }

    @Override
    public void unregisterLogConsumer(final String consumerId, final String extinfo) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> registerLogConsumerCallable = new LServerCallable<Void>(OperationContext.OperationType.EXPORTER){

                @Override
                public Void call() throws Exception {
                    this.server.unregisterLogConsumer(consumerId, extinfo);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(registerLogConsumerCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
        this.blockingAndWaitForSuccess(consumerId, AsyncDDLType.REGISTER_CONSUMER, this.ddlOperationTimeout);
    }

    @Override
    public List<ExporterConsumer> listConsumers() throws LindormException {
        this.checkOpen();
        List<String> idcs = this.lconnection.getAllIDC();
        HashMap<String, List<ExporterConsumer>> idcConsumers = new HashMap<String, List<ExporterConsumer>>();
        for (final String idc : idcs) {
            try {
                LServerCallable<List<ExporterConsumer>> callable = new LServerCallable<List<ExporterConsumer>>(OperationContext.OperationType.EXPORTER){

                    @Override
                    public List<ExporterConsumer> call() throws Exception {
                        return this.server.listConsumers(idc);
                    }
                };
                List<ExporterConsumer> consumers = this.lconnection.getExporterRetryingCaller(this.ddlOperationTimeout, idc).withRetries(callable);
                if (consumers == null) continue;
                idcConsumers.put(idc, consumers);
            }
            catch (Throwable t) {
                throw new LindormException(t);
            }
        }
        if (idcConsumers.size() != idcs.size() && idcConsumers.size() > 0) {
            LOG.warn((Object)("Exporter consumer inconsistent , consumers : " + idcConsumers));
            return null;
        }
        List result = null;
        for (String xidc : idcs) {
            if (result == null) {
                result = (List)idcConsumers.get(xidc);
                continue;
            }
            List idcConsumer = (List)idcConsumers.get(xidc);
            if (idcConsumer.size() != result.size()) {
                LOG.warn((Object)("Exporter consumer inconsistent , consumers : " + idcConsumers));
                return null;
            }
            for (ExporterConsumer consumer : idcConsumer) {
                if (result.contains(consumer)) continue;
                LOG.warn((Object)("Exporter consumer inconsistent , consumers : " + idcConsumers));
                return null;
            }
        }
        return result;
    }

    @Override
    public FileSystemInfo getFileSystemInfo(final String consumerId, final LindormIdc idc) throws IOException {
        this.checkOpen();
        try {
            LServerCallable<FileSystemInfo> callable = new LServerCallable<FileSystemInfo>(OperationContext.OperationType.CREATE){

                @Override
                public FileSystemInfo call() throws Exception {
                    return this.server.getFileSystemInfo(consumerId, idc.getIdc());
                }
            };
            return this.lconnection.getExporterRetryingCaller(this.ddlOperationTimeout, idc.getIdc()).withRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public List<ExporterLogFile> getAllLogs(String consumerId, String extInfo) throws IOException {
        this.checkOpen();
        ArrayList<ExporterLogFile> result = new ArrayList<ExporterLogFile>();
        for (String idc : this.lconnection.getAllIDC()) {
            try {
                List<ExporterLogFile> exporterLogFiles = this.getAllLogsOfIdc(consumerId, extInfo, idc);
                if (exporterLogFiles == null) continue;
                result.addAll(exporterLogFiles);
            }
            catch (Throwable t) {
                LOG.error((Object)("Get idc log exception " + idc), t);
                throw new LindormException(t);
            }
        }
        return result;
    }

    private List<ExporterLogFile> getAllLogsOfIdc(final String consumerId, final String extInfo, String idc) throws IOException {
        ArrayList<ExporterLogFile> result = new ArrayList<ExporterLogFile>();
        LServerCallable<List<ExporterLogFile>> callable = new LServerCallable<List<ExporterLogFile>>(OperationContext.OperationType.GETEXPLOGS){

            @Override
            public List<ExporterLogFile> call() throws Exception {
                return this.server.getAllLogs(consumerId, extInfo);
            }
        };
        List<ExporterLogFile> exporterLogFiles = this.lconnection.getExporterRetryingCaller(this.ddlOperationTimeout, idc).withRetries(callable);
        if (exporterLogFiles != null) {
            result.addAll(exporterLogFiles);
        }
        return result;
    }

    @Override
    public Map<String, List<ExporterLogFile>> getAllLogs(String consumerId, String extInfo, boolean makeSureAllIdcSuccess) throws IOException {
        this.checkOpen();
        HashMap<String, List<ExporterLogFile>> idcLogMap = new HashMap<String, List<ExporterLogFile>>();
        for (String idc : this.lconnection.getAllIDC()) {
            try {
                String idcExtInfo = idc + "," + (extInfo == null ? "" : extInfo);
                List<ExporterLogFile> exporterLogFiles = this.getAllLogsOfIdc(consumerId, idcExtInfo, idc);
                if (exporterLogFiles == null) continue;
                idcLogMap.put(idc, exporterLogFiles);
            }
            catch (Throwable t) {
                LOG.error((Object)("Get idc log exception " + idc), t);
                if (!makeSureAllIdcSuccess) continue;
                throw new LindormException(t);
            }
        }
        return idcLogMap;
    }

    @Override
    public void completeLog(final String consumerId, List<ExporterLogFile> logs, final String extInfo) throws IOException {
        this.checkOpen();
        final HashMap idcLogMap = new HashMap();
        for (ExporterLogFile exporterLogFile : logs) {
            String idc = exporterLogFile.getLindormIdc().getIdc();
            if (idcLogMap.get(idc) == null) {
                idcLogMap.put(idc, new ArrayList());
            }
            ((List)idcLogMap.get(idc)).add(exporterLogFile);
        }
        for (final String idc : idcLogMap.keySet()) {
            try {
                LServerCallable<Void> callable = new LServerCallable<Void>(OperationContext.OperationType.COMPLETEEXPLOG){

                    @Override
                    public Void call() throws Exception {
                        this.server.completeLog(consumerId, (List)idcLogMap.get(idc), extInfo);
                        return null;
                    }
                };
                this.lconnection.getExporterRetryingCaller(this.ddlOperationTimeout, idc).withRetries(callable);
            }
            catch (Throwable t) {
                throw new LindormException(t);
            }
        }
    }

    @Override
    public void turnOnExporter() throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> turnOnExporterCallable = new LServerCallable<Void>(OperationContext.OperationType.EXPORTER){

                @Override
                public Void call() throws Exception {
                    this.server.turnOnExporter();
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(turnOnExporterCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
        this.blockingAndWaitForSuccess(AsyncDDLType.TURNON_EXPORTER.name(), AsyncDDLType.TURNON_EXPORTER, this.ddlOperationTimeout);
    }

    @Override
    public void turnOffExporter() throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> turnOffExporterCallable = new LServerCallable<Void>(OperationContext.OperationType.EXPORTER){

                @Override
                public Void call() throws Exception {
                    this.server.turnOffExporter();
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(turnOffExporterCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
        this.blockingAndWaitForSuccess(AsyncDDLType.TURNOFF_EXPORTER.name(), AsyncDDLType.TURNOFF_EXPORTER, this.ddlOperationTimeout);
    }

    @Override
    public Map<String, String> exporterStatus() throws IOException {
        this.checkOpen();
        List<String> idcs = this.lconnection.getAllIDC();
        HashMap<String, String> result = new HashMap<String, String>();
        for (final String idc : idcs) {
            try {
                LServerCallable<String> exporterStatusCallable = new LServerCallable<String>(OperationContext.OperationType.EXPORTER){

                    @Override
                    public String call() throws Exception {
                        return this.server.exporterStatus(idc);
                    }
                };
                result.put(idc, this.lconnection.getExporterRetryingCaller(this.ddlOperationTimeout, idc).withRetries(exporterStatusCallable));
            }
            catch (Throwable t) {
                throw new LindormException(t);
            }
        }
        return result;
    }

    public void registerLogConsumerAsync(final String userName, final ExporterConsumer consumer) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> registerLogConsumerCallable = new LServerCallable<Void>(OperationContext.OperationType.EXPORTER){

                @Override
                public Void call() throws Exception {
                    this.server.registerLogConsumer(userName, consumer.getConsumerId(), consumer.getConsumerName());
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(registerLogConsumerCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
        this.blockingAndWaitForSuccess(consumer.getConsumerId(), AsyncDDLType.REGISTER_CONSUMER, this.ddlOperationTimeout);
    }

    private void blockingAndWaitForSuccess(String key, AsyncDDLType type, int blockTimeInSecond) throws LindormException {
        long startTime = System.currentTimeMillis();
        long blockTimeInMs = blockTimeInSecond;
        if (blockTimeInSecond != Integer.MAX_VALUE) {
            blockTimeInMs = blockTimeInSecond * 1000;
        }
        long deadline = startTime + blockTimeInMs;
        for (int i = 0; i < this.maxRetryDDL; ++i) {
            long remaining = deadline - System.currentTimeMillis();
            if (remaining <= 0L) {
                throw new LindormException("Timed out when waiting for table: " + key + " to finish operation: " + type);
            }
            try {
                long sleepTime = this.ddlPause;
                if (i > 60) {
                    sleepTime = this.ddlPause * 10;
                }
                sleepTime = sleepTime < remaining ? sleepTime : remaining;
                Thread.sleep(sleepTime);
                Pair<Integer, Integer> status = this.getOperationStatus(key, type);
                if (status.getFirst() == 0) {
                    return;
                }
                LOG.info((Object)("Progess of operation for : " + key + ", undone idcs : " + status.getFirst() + " total idcs : " + status.getSecond()));
                continue;
            }
            catch (LindormException e) {
                LOG.warn((Object)("failed to get table status for " + key + ", operation type: " + type + ", Retry count : " + i), (Throwable)e);
                continue;
            }
            catch (InterruptedException e) {
                throw new LindormException("Interrupt while waiting for " + key + " ddl operation to finish ", e);
            }
        }
        throw new LindormException("Retry exhausted for table operation " + key + " Max wait time : " + (System.currentTimeMillis() - startTime));
    }

    private Pair<Integer, Integer> getOperationStatus(final String key, final AsyncDDLType type) throws LindormException {
        this.checkOpen();
        try {
            if (key == null || key.isEmpty()) {
                throw new LindormException("Key cann't be null or emtpy.");
            }
            LServerCallable<Pair<Integer, Integer>> getOperationStatusCallable = new LServerCallable<Pair<Integer, Integer>>(OperationContext.OperationType.CHECKSTATE){

                @Override
                public Pair<Integer, Integer> call() throws Exception {
                    return this.server.getExporterOperationStatus(key, type);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(getOperationStatusCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }
}

