/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.TableService;
import com.alibaba.lindorm.client.core.BasicDDLService;
import com.alibaba.lindorm.client.core.tableservice.LAccumulate;
import com.alibaba.lindorm.client.core.tableservice.LAggregate;
import com.alibaba.lindorm.client.core.tableservice.LAppend;
import com.alibaba.lindorm.client.core.tableservice.LDelete;
import com.alibaba.lindorm.client.core.tableservice.LIncrease;
import com.alibaba.lindorm.client.core.tableservice.LSelect;
import com.alibaba.lindorm.client.core.tableservice.LUpsert;
import com.alibaba.lindorm.client.dml.Accumulate;
import com.alibaba.lindorm.client.dml.Aggregate;
import com.alibaba.lindorm.client.dml.Append;
import com.alibaba.lindorm.client.dml.Delete;
import com.alibaba.lindorm.client.dml.Increase;
import com.alibaba.lindorm.client.dml.Select;
import com.alibaba.lindorm.client.dml.Upsert;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LindormTableService
extends BasicDDLService
implements TableService {
    public static final Log LOG = LogFactory.getLog(LindormTableService.class);
    private static AtomicInteger tableServiceCount = new AtomicInteger(0);

    public LindormTableService() {
    }

    public LindormTableService(LindormClientConfig config) throws LindormException {
        this(config, "LindormTableService" + tableServiceCount.getAndIncrement());
    }

    public LindormTableService(LindormClientConfig config, String serviceName) throws LindormException {
        super(config, serviceName);
        if (config.getBoolean("lindorm.client.prefetch.routecache", false)) {
            this.prefetchRouteCache(null);
        }
    }

    @Override
    public Select select() throws LindormException {
        this.checkOpen();
        return new LSelect(this);
    }

    @Override
    public Upsert upsert() throws LindormException {
        this.checkOpen();
        return new LUpsert(this);
    }

    @Override
    public Delete delete() throws LindormException {
        this.checkOpen();
        return new LDelete(this);
    }

    @Override
    public Increase increase() throws LindormException {
        this.checkOpen();
        return new LIncrease(this);
    }

    @Override
    public Append append() throws LindormException {
        this.checkOpen();
        return new LAppend(this);
    }

    @Override
    public Aggregate aggregate() throws LindormException {
        this.checkOpen();
        return new LAggregate(this);
    }

    @Override
    public Accumulate accumulate() throws LindormException {
        this.checkOpen();
        return new LAccumulate(this);
    }
}

