/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.Interval;
import com.alibaba.lindorm.client.core.expression.ComparisonExpression;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.dml.ConditionList;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class ColumnSlot {
    private final LColumn column;
    private final Interval interval;
    private final SortedSet<Point> exclusions;
    private int hashCode;

    private ColumnSlot(LColumn column, Interval interval, SortedSet<Point> exclusions) {
        this.column = column;
        this.interval = interval;
        this.exclusions = exclusions;
    }

    public static ColumnSlot create(LColumn column, Interval interval) {
        return new ColumnSlot(column, interval, null);
    }

    public static ColumnSlot create(LColumn column, Interval interval, SortedSet<Point> exclusions) {
        if (exclusions != null) {
            Iterator iterator = exclusions.iterator();
            while (iterator.hasNext()) {
                if (interval.contains(((Point)iterator.next()).value)) continue;
                iterator.remove();
            }
        }
        return new ColumnSlot(column, interval, exclusions);
    }

    public static ColumnSlot create(LColumn column, ComparisonExpression expression) throws IllegalDataException {
        ConditionFactory.CompareOp op = CompilerUtils.transformCompareOp(column.getSortOrder(), expression.getOp());
        byte[] value = ColumnSlot.evaluate(column, op, expression);
        Interval interval = null;
        TreeSet<Point> exclusions = null;
        switch (op) {
            case NOT_EQUAL: {
                interval = Interval.EVERYTHING_RANGE;
                exclusions = new TreeSet<Point>();
                exclusions.add(new Point(value));
                break;
            }
            case EQUAL: {
                interval = Interval.create(value, true, value, true);
                break;
            }
            case LESS: {
                interval = Interval.create(Interval.UNBOUND, false, value, false);
                break;
            }
            case LESS_OR_EQUAL: {
                interval = Interval.create(Interval.UNBOUND, false, value, true);
                break;
            }
            case GREATER: {
                interval = Interval.create(value, false, Interval.UNBOUND, false);
                break;
            }
            case GREATER_OR_EQUAL: {
                interval = Interval.create(value, true, Interval.UNBOUND, false);
                break;
            }
            case IS: {
                interval = value == null ? null : Interval.create(value, true, value, true);
                break;
            }
            case IS_NOT: {
                interval = Interval.EVERYTHING_RANGE;
                if (value == null) break;
                exclusions = new TreeSet();
                exclusions.add(new Point(value));
            }
        }
        return new ColumnSlot(column, interval, exclusions);
    }

    private static byte[] evaluate(LColumn column, ConditionFactory.CompareOp op, ComparisonExpression expression) throws IllegalDataException {
        if (expression.getValue() == null && column.isPrimaryKey() && !column.isStoreNull() && ConditionFactory.CompareOp.isNullValueOp(op)) {
            return null;
        }
        return expression.evaluateRHS(column);
    }

    public ColumnSlot intersect(ColumnSlot otherColumnSlot) {
        if (!this.isNullValue() && !otherColumnSlot.isNullValue()) {
            TreeSet<Point> allExclusions = new TreeSet<Point>();
            Interval result = this.interval.intersect(otherColumnSlot.interval);
            if (!this.collectExclusions(allExclusions, result, this.exclusions) || !this.collectExclusions(allExclusions, result, otherColumnSlot.exclusions)) {
                return new ColumnSlot(this.column, Interval.EMPTY_RANGE, null);
            }
            return new ColumnSlot(this.column, result, allExclusions.size() > 0 ? allExclusions : null);
        }
        if (this.isNullValue() && otherColumnSlot.isNullValue()) {
            return new ColumnSlot(this.column, null, null);
        }
        return new ColumnSlot(this.column, Interval.EMPTY_RANGE, null);
    }

    private boolean collectExclusions(SortedSet<Point> allExclusions, Interval interval, SortedSet<Point> exclusions) {
        if (exclusions == null) {
            return true;
        }
        for (Point exclusion : exclusions) {
            if (!interval.contains(exclusion.value)) continue;
            if (interval.isSingleValue()) {
                return false;
            }
            allExclusions.add(exclusion);
        }
        return true;
    }

    public boolean isEmpty() {
        return this.interval != null && this.interval.equals(Interval.EMPTY_RANGE);
    }

    public boolean isNullValue() {
        return this.interval == null;
    }

    public boolean isNotNullValue() {
        return this.interval.equals(Interval.EVERYTHING_RANGE) && this.exclusions == null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append("(");
            builder.append(this.toReadableString(this.column, this.interval));
            if (this.exclusions != null) {
                for (Point exclusion : this.exclusions) {
                    builder.append(" AND (");
                    builder.append(Bytes.toString(this.column.getColumnName()));
                    builder.append(" != ");
                    builder.append(LDataType.toObject(this.column, exclusion.value));
                    builder.append(")");
                }
            }
            builder.append(")");
        }
        catch (IllegalDataException illegalDataException) {
            // empty catch block
        }
        return builder.toString();
    }

    private String toReadableString(LColumn column, Interval interval) throws IllegalDataException {
        StringBuilder str = new StringBuilder();
        str.append(Bytes.toString(column.getColumnName()));
        if (interval == null) {
            str.append(" is null");
            return str.toString();
        }
        if (interval.isSingleValue()) {
            Object value = LDataType.toObject(column, interval.getLower());
            str.append(value == null ? " is " : " = ");
            str.append(value);
            return str.toString();
        }
        if (interval.equals(Interval.EMPTY_RANGE)) {
            if (this.exclusions == null) {
                str.append(" is not null");
            } else {
                str.append(" in ");
                str.append("()");
            }
            return str.toString();
        }
        str.append(" in ");
        if (interval.isLowerInclusive()) {
            str.append("[");
        } else {
            str.append("(");
        }
        if (interval.isLowerUnbound()) {
            str.append("*");
        } else {
            str.append(LDataType.toObject(column, interval.getLower()));
        }
        str.append(" - ");
        if (interval.isUpperUnbound()) {
            str.append("*");
        } else {
            str.append(LDataType.toObject(column, interval.getUpper()));
        }
        if (interval.isUpperInclusive()) {
            str.append("]");
        } else {
            str.append(")");
        }
        return str.toString();
    }

    public LColumn getColumn() {
        return this.column;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public SortedSet<Point> getExclusions() {
        return this.exclusions;
    }

    public Condition toExpression() throws IllegalDataException, IllegalRequestException {
        ConditionList andExpression = ConditionFactory.and();
        if (this.isNullValue()) {
            andExpression.add(new ComparisonExpression(this.column, ConditionFactory.CompareOp.IS, null));
        } else if (this.isNotNullValue()) {
            andExpression.add(new ComparisonExpression(this.column, ConditionFactory.CompareOp.IS_NOT, null));
        } else if (this.interval.isSingleValue()) {
            Object value = LDataType.toObject(this.column, this.interval.getLower());
            if (value == null) {
                andExpression.add(new ComparisonExpression(this.column, ConditionFactory.CompareOp.IS, null));
            } else {
                andExpression.add(new ComparisonExpression(this.column, ConditionFactory.CompareOp.EQUAL, this.interval.getLower()));
            }
        } else {
            if (this.interval != Interval.EVERYTHING_RANGE) {
                if (this.interval.isLowerUnbound()) {
                    andExpression.add(new ComparisonExpression(this.column, this.getComparisonExpressionOp(this.column, ConditionFactory.CompareOp.LESS, this.interval.isUpperInclusive()), this.interval.getUpper()));
                } else if (this.interval.isUpperUnbound()) {
                    andExpression.add(new ComparisonExpression(this.column, this.getComparisonExpressionOp(this.column, ConditionFactory.CompareOp.GREATER, this.interval.isLowerInclusive()), this.interval.getLower()));
                } else {
                    andExpression.add(new ComparisonExpression(this.column, this.getComparisonExpressionOp(this.column, ConditionFactory.CompareOp.LESS, this.interval.isUpperInclusive()), this.interval.getUpper()));
                    andExpression.add(new ComparisonExpression(this.column, this.getComparisonExpressionOp(this.column, ConditionFactory.CompareOp.GREATER, this.interval.isLowerInclusive()), this.interval.getLower()));
                }
            }
            if (this.exclusions != null) {
                for (Point exclusion : this.exclusions) {
                    if (SchemaUtils.isNullValueBytes(this.column, exclusion.getValue(), this.column.getSortOrder())) {
                        andExpression.add(new ComparisonExpression(this.column, ConditionFactory.CompareOp.IS_NOT, exclusion.getValue()));
                        continue;
                    }
                    andExpression.add(new ComparisonExpression(this.column, ConditionFactory.CompareOp.NOT_EQUAL, exclusion.getValue()));
                }
            }
        }
        return andExpression.getConditions().size() > 1 ? andExpression : andExpression.getConditions().get(0);
    }

    private ConditionFactory.CompareOp getComparisonExpressionOp(LColumn column, ConditionFactory.CompareOp op, boolean isInclusive) {
        if (isInclusive) {
            op = op == ConditionFactory.CompareOp.LESS ? ConditionFactory.CompareOp.LESS_OR_EQUAL : ConditionFactory.CompareOp.GREATER_OR_EQUAL;
        }
        return CompilerUtils.transformCompareOp(column.getSortOrder(), op);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.column.hashCode() * 31 + (this.interval == null ? 0 : this.interval.hashCode());
            if (this.exclusions != null) {
                for (Point exclusion : this.exclusions) {
                    result = 31 * result + exclusion.hashCode();
                }
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ColumnSlot)) {
            return false;
        }
        ColumnSlot other = (ColumnSlot)obj;
        if (!this.column.equals(other.column)) {
            return false;
        }
        if (this.interval == null ? other.interval != null : !this.interval.equals(other.interval)) {
            return false;
        }
        return this.exclusions == null ? other.exclusions == null : this.exclusions.equals(other.exclusions);
    }

    public static class Point
    implements Comparable<Point> {
        private byte[] value;
        private int hashCode;

        public Point(byte[] value) {
            this.value = value;
        }

        public byte[] getValue() {
            return this.value;
        }

        public int hashCode() {
            if (this.hashCode == 0 && this.value != null && this.value.length > 0) {
                this.hashCode = Bytes.hashCode(this.value, 0, this.value.length);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Point)) {
                return false;
            }
            Point other = (Point)obj;
            return Bytes.compareTo(this.value, other.value) == 0;
        }

        @Override
        public int compareTo(Point other) {
            if (this == other) {
                return 0;
            }
            return Bytes.compareTo(this.value, other.value);
        }
    }
}

