/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.AndOrExpression;
import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.ExpressionVisitor;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionList;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.List;

public class AndExpression
extends AndOrExpression {
    public AndExpression() {
        super(ConditionList.LogicalOp.AND);
    }

    public AndExpression(Condition ... conditions) throws IllegalRequestException {
        super(ConditionList.LogicalOp.AND);
        AndExpression.validateChildrenConditions(conditions);
        this.conditions = CollectionUtils.newArrayListWithCapacity(conditions.length);
        for (Condition expr : conditions) {
            AndExpression.validateChildrenCondition(expr);
            this.conditions.add(expr);
        }
    }

    public AndExpression(List<Expression> conditions) throws IllegalRequestException {
        super(ConditionList.LogicalOp.AND);
        AndExpression.validateChildrenConditions(conditions);
        this.conditions = CollectionUtils.newArrayListWithCapacity(conditions.size());
        for (Expression expr : conditions) {
            AndExpression.validateChildrenCondition(expr);
            this.conditions.add((Condition)expr);
        }
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws LindormException {
        AndExpression.validateChildrenConditions(this.conditions);
        List<T> results = this.acceptChildren(visitor, this.conditions);
        return visitor.visitLeave(this, results);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AndExpression)) {
            return false;
        }
        AndExpression c = (AndExpression)obj;
        return this.conditions.equals(c.conditions);
    }

    @Override
    protected boolean isStopValue(boolean value) {
        return !value;
    }
}

