/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LDServerList {
    static final Log LOG = LogFactory.getLog(LDServerList.class);
    ConcurrentHashMap<String, ConcurrentSkipListSet<LDServerAddress>> serverIDCMap;
    Set<LDServerAddress> cachedServerList = new HashSet<LDServerAddress>();

    public LDServerList() {
        this.serverIDCMap = new ConcurrentHashMap();
    }

    public void addLDServerAddress(LDServerAddress address) throws IOException {
        ConcurrentSkipListSet<LDServerAddress> servers = this.serverIDCMap.get(address.getIdc());
        if (servers == null) {
            LOG.warn((Object)("IDC " + address.getIdc() + " is not included in this list " + address));
            return;
        }
        if (!this.isServerAddressValid(address)) {
            return;
        }
        if (!servers.contains(address)) {
            servers.add(address);
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(address + " is already in this server list"));
        }
    }

    public void removeLDServerAddress(LDServerAddress address) {
        ConcurrentSkipListSet<LDServerAddress> servers = this.serverIDCMap.get(address.getIdc());
        if (servers == null) {
            LOG.warn((Object)("IDC " + address.getIdc() + " is not included in this list, ignore to remove server " + address));
            return;
        }
        if (servers.remove(address)) {
            LOG.debug((Object)("Removed " + address + " from server list"));
        }
    }

    public void updateFromSeedServer(List<LDServerAddress> aliveServers, List<LDServerAddress> expiredServers) {
        ConcurrentHashMap<String, ConcurrentSkipListSet<LDServerAddress>> serverIDCMapTemp = new ConcurrentHashMap<String, ConcurrentSkipListSet<LDServerAddress>>();
        for (LDServerAddress server : aliveServers) {
            String idc = server.getIdc();
            if (idc == null || idc.length() == 0) continue;
            ConcurrentSkipListSet<LDServerAddress> list = (ConcurrentSkipListSet<LDServerAddress>)serverIDCMapTemp.get(server.getIdc());
            if (list == null) {
                list = new ConcurrentSkipListSet<LDServerAddress>();
                serverIDCMapTemp.put(server.getIdc(), list);
            }
            list.add(server);
        }
        HashSet<LDServerAddress> cachedServerListTemp = new HashSet<LDServerAddress>(aliveServers);
        for (LDServerAddress address : this.cachedServerList) {
            if (cachedServerListTemp.contains(address)) continue;
            expiredServers.add(address);
        }
        this.cachedServerList = cachedServerListTemp;
        this.serverIDCMap = serverIDCMapTemp;
    }

    public boolean isServerAddressValid(LDServerAddress ldServerAddress) {
        return this.cachedServerList.contains(ldServerAddress);
    }

    public List<String> getAllIDCNames() {
        return new ArrayList<String>(this.serverIDCMap.keySet());
    }

    public List<LDServerAddress> getLDServerByIDC(String idc) {
        ConcurrentSkipListSet<LDServerAddress> servers = this.serverIDCMap.get(idc);
        if (servers == null) {
            return new ArrayList<LDServerAddress>();
        }
        return new ArrayList<LDServerAddress>(servers);
    }

    public boolean isServerListEmpty() {
        for (Map.Entry<String, ConcurrentSkipListSet<LDServerAddress>> entry : this.serverIDCMap.entrySet()) {
            ConcurrentSkipListSet<LDServerAddress> list = entry.getValue();
            if (list == null || list.size() == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (Map.Entry<String, ConcurrentSkipListSet<LDServerAddress>> entry : this.serverIDCMap.entrySet()) {
            builder.append(" [IDC :" + entry.getKey() + ", servers : ");
            builder.append(StringUtils.join(",", (Iterable)entry.getValue()));
            builder.append("] ");
        }
        builder.append("}");
        return builder.toString();
    }
}

