/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.core.ipc.LindormObject;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SyncState
implements LindormObject {
    public static final char SINK_SOURCE_DELIMITER = '.';
    Map<String, Long> syncStates;

    public SyncState() {
        this.syncStates = new HashMap<String, Long>();
    }

    public SyncState(Map<String, Long> syncStates) {
        this.syncStates = syncStates;
    }

    public Long getSyncState(String sourceIdc, String sinkIdc) {
        return this.syncStates.get(SyncState.getPeer(sourceIdc, sinkIdc));
    }

    public Pair<String, String> getMostDelayedReplicaPair() {
        long mostDelayedSyncTime = System.currentTimeMillis();
        Pair<String, String> mostDelayedReplicaPeer = null;
        for (Map.Entry<String, Long> entry : this.syncStates.entrySet()) {
            if (entry.getValue() >= mostDelayedSyncTime) continue;
            mostDelayedReplicaPeer = SyncState.parsePeer(entry.getKey());
            mostDelayedSyncTime = entry.getValue();
        }
        return mostDelayedReplicaPeer;
    }

    public Long getMostDelayedSyncTime() {
        long mostDelayedSyncTime = System.currentTimeMillis();
        for (Map.Entry<String, Long> entry : this.syncStates.entrySet()) {
            if (entry.getValue() >= mostDelayedSyncTime) continue;
            mostDelayedSyncTime = entry.getValue();
        }
        return mostDelayedSyncTime;
    }

    public static Pair<String, String> parsePeer(String peer) {
        int delimiter = peer.indexOf(46);
        if (delimiter < 0) {
            throw new IllegalArgumentException("Failed to parse replica peer " + peer);
        }
        return new Pair<String, String>(peer.substring(0, delimiter), peer.substring(delimiter + 1));
    }

    public static String getPeer(String sourceIdc, String sinkInc) {
        return sourceIdc + '.' + sinkInc;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        if (this.syncStates != null) {
            WritableUtils.writeVInt(out, this.syncStates.size());
            for (Map.Entry<String, Long> entry : this.syncStates.entrySet()) {
                WritableUtils.writeString(out, entry.getKey());
                WritableUtils.writeVLong(out, entry.getValue());
            }
        } else {
            WritableUtils.writeVInt(out, 0);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        int size = WritableUtils.readVInt(in);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                String key = WritableUtils.readString(in);
                Long value = WritableUtils.readVLong(in);
                this.syncStates.put(key, value);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.syncStates != null) {
            for (Map.Entry<String, Long> entry : this.syncStates.entrySet()) {
                builder.append(" concensus pair: ");
                builder.append(entry.getKey());
                builder.append(", sync time: ");
                builder.append(entry.getValue());
                builder.append("\r\n");
            }
        }
        return builder.toString();
    }
}

