/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.metrics;

import com.alibaba.lindorm.client.core.metrics.OperationMetricsSnapshot;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class OperationMetrics {
    private AtomicLong successOps = new AtomicLong(0L);
    private AtomicLong errorOps = new AtomicLong(0L);
    private AtomicLong sum = new AtomicLong(0L);
    private AtomicLong max = new AtomicLong(0L);
    private AtomicLong rowCount = new AtomicLong(0L);
    private AtomicLongArray responseSpreads = new AtomicLongArray(9);
    long startTime = System.currentTimeMillis();

    public void onSuccess(long timeTook, int row) {
        if (row <= 0 || timeTook < 0L) {
            return;
        }
        if (timeTook <= 0L) {
            this.responseSpreads.addAndGet(0, 1L);
        } else if (timeTook > 0L && timeTook <= 1L) {
            this.responseSpreads.addAndGet(1, 1L);
        } else if (timeTook > 1L && timeTook <= 5L) {
            this.responseSpreads.addAndGet(2, 1L);
        } else if (timeTook > 5L && timeTook <= 10L) {
            this.responseSpreads.addAndGet(3, 1L);
        } else if (timeTook > 10L && timeTook <= 50L) {
            this.responseSpreads.addAndGet(4, 1L);
        } else if (timeTook > 50L && timeTook <= 100L) {
            this.responseSpreads.addAndGet(5, 1L);
        } else if (timeTook > 100L && timeTook <= 500L) {
            this.responseSpreads.addAndGet(6, 1L);
        } else if (timeTook > 500L && timeTook <= 1000L) {
            this.responseSpreads.addAndGet(7, 1L);
        } else if (timeTook > 1000L) {
            this.responseSpreads.addAndGet(8, 1L);
        }
        this.rowCount.addAndGet(row);
        this.sum.addAndGet(timeTook);
        this.setMax(timeTook);
        this.successOps.incrementAndGet();
    }

    public void onError(Throwable t) {
        this.errorOps.getAndIncrement();
    }

    private void setMax(long potentialMax) {
        boolean done = false;
        while (!done) {
            long currentMax = this.max.get();
            done = currentMax >= potentialMax || this.max.compareAndSet(currentMax, potentialMax);
        }
    }

    public OperationMetricsSnapshot snapshot(long now) {
        OperationMetricsSnapshot snapshot = new OperationMetricsSnapshot();
        snapshot.setStartTime(this.startTime);
        snapshot.setEndTime(now);
        snapshot.setTotalRowCount(this.rowCount.getAndSet(0L));
        snapshot.setSuccessOps(this.successOps.getAndSet(0L));
        snapshot.setErrorOps(this.errorOps.getAndSet(0L));
        snapshot.setSumTime(this.sum.getAndSet(0L));
        snapshot.setMaxTime(this.max.getAndSet(0L));
        snapshot.setRt0(this.responseSpreads.getAndSet(0, 0L));
        snapshot.setRt1(this.responseSpreads.getAndSet(1, 0L));
        snapshot.setRt5(this.responseSpreads.getAndSet(2, 0L));
        snapshot.setRt10(this.responseSpreads.getAndSet(3, 0L));
        snapshot.setRt50(this.responseSpreads.getAndSet(4, 0L));
        snapshot.setRt100(this.responseSpreads.getAndSet(5, 0L));
        snapshot.setRt500(this.responseSpreads.getAndSet(6, 0L));
        snapshot.setRt1000(this.responseSpreads.getAndSet(7, 0L));
        snapshot.setRt1001(this.responseSpreads.getAndSet(8, 0L));
        this.startTime = now;
        if (snapshot.getTotalRowCount() == 0L) {
            return null;
        }
        return snapshot;
    }
}

