/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.AsyncCallback;
import com.alibaba.lindorm.client.core.LindormTableService;
import com.alibaba.lindorm.client.core.expression.ExpressionType;
import com.alibaba.lindorm.client.core.ipc.ClientCompletableFuture;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.RetryingCaller;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.tableservice.DmlOperation;
import com.alibaba.lindorm.client.core.tableservice.LMutationResult;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.Append;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.DataType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.Future;

public class LAppend
extends DmlOperation
implements Append {
    private boolean returnResults = false;
    private Condition where;
    private Row values = new Row(3);

    public LAppend() {
    }

    public LAppend(LindormTableService service) {
        super(service);
    }

    @Override
    public Append into(String tableName) throws LindormException {
        if (this.service != null) {
            this.namespace = this.service.getNamespace();
        }
        this.tableName = tableName;
        return this;
    }

    @Override
    public Append add(String columnName, Object value) throws LindormException {
        return this.add(null, Bytes.toBytes(columnName), value);
    }

    @Override
    public Append add(String familyName, String columnName, Object value) throws LindormException {
        if (StringUtils.isNullOrEmpty(columnName)) {
            throw new IllegalRequestException("Column name cannot be null or empty.");
        }
        return this.add(familyName != null ? Bytes.toBytes(familyName) : null, Bytes.toBytes(columnName), value);
    }

    @Override
    public Append add(byte[] columnName, Object value) throws LindormException {
        return this.add(null, columnName, value);
    }

    @Override
    public Append add(byte[] familyName, byte[] columnName, Object value) throws LindormException {
        if (value == null) {
            throw new IllegalRequestException("Cannot append null values.");
        }
        DataType type = LDataTypeFactory.INSTANCE.getTypeByClass(value.getClass()).getClientType();
        if (type != DataType.STRING && type != DataType.VARBINARY && type != DataType.BINARY) {
            throw new IllegalRequestException("APPEND supports STRING/VARBINARY types only, but has " + (Object)((Object)type));
        }
        this.values.add(new ColumnValue(familyName, columnName, value, type, Long.MAX_VALUE));
        return this;
    }

    @Override
    public Append where(Condition where) throws LindormException {
        this.where = where;
        return this;
    }

    @Override
    public Append setReturnResults(boolean returnResults) {
        this.returnResults = returnResults;
        return this;
    }

    @Override
    public boolean isReturnResults() {
        return this.returnResults;
    }

    public Condition getWhere() {
        return this.where;
    }

    public Row getValues() {
        return this.values;
    }

    private LServerCallable<LMutationResult> buildAppendCall() {
        return new LServerCallable<LMutationResult>((DmlOperation)this, OperationContext.OperationType.APPEND){

            @Override
            public LMutationResult call() throws Exception {
                return this.server.append(LAppend.this);
            }
        };
    }

    @Override
    public Future<Row> executeAsync() throws LindormException {
        final ClientCompletableFuture<Row> future = new ClientCompletableFuture<Row>();
        this.executeAsync(new AsyncCallback<Row>(){

            @Override
            public void onComplete(Row result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    @Override
    public void executeAsync(AsyncCallback<Row> callback) throws LindormException {
        LAppend.validate(this);
        if (this.isEmpty()) {
            callback.onComplete(null);
            return;
        }
        this.setupRouteKey();
        OperationContext.OperationType operationType = OperationContext.OperationType.APPEND;
        RetryingCaller<LMutationResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        LServerCallable<LMutationResult> appendCallable = this.buildAppendCall();
        Object eagleEyeContext = this.service.startEagleeyeTraceAsync(this.tableName, operationType);
        AsyncAppendHandler asyncUpsertHandler = new AsyncAppendHandler(callback, operationType, System.currentTimeMillis(), eagleEyeContext);
        retryingCaller.withRetriesAsync(appendCallable, asyncUpsertHandler);
    }

    @Override
    public Row execute() throws LindormException {
        LAppend.validate(this);
        if (this.isEmpty()) {
            return null;
        }
        long start = System.currentTimeMillis();
        this.service.startEagleeyeTrace(this.tableName, OperationContext.OperationType.APPEND);
        try {
            RetryingCaller<LMutationResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
            LServerCallable<LMutationResult> appendCallable = this.buildAppendCall();
            this.setupRouteKey();
            LMutationResult response = retryingCaller.withRetries(appendCallable);
            this.handleResultAttributes(this, response);
            Object[] results = response.getResults();
            Row ret = (Row)results[0];
            this.service.getLConnection().getTableMetricsManager().onOperationSuccess(this.namespace, this.tableName, OperationContext.OperationType.APPEND, System.currentTimeMillis() - start, 1);
            Row row = ret;
            return row;
        }
        catch (Throwable t) {
            String msg = this.buildErrorMsg(OperationContext.OperationType.APPEND, t, System.currentTimeMillis() - start);
            LindormException finalError = new LindormException(msg);
            this.service.getLConnection().getTableMetricsManager().onOperationError(this.namespace, this.tableName, OperationContext.OperationType.APPEND, finalError);
            throw finalError;
        }
        finally {
            this.service.endEagleeyeTrace();
        }
    }

    @Override
    protected byte[] computeRowKey(TableMeta meta) throws LindormException {
        try {
            return CompilerUtils.getRowKeyForRouting(meta, this.where);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("APPEND ");
        for (ColumnValue cv : this.values.getColumnValues()) {
            str.append(cv.getColumnKey().toString());
            str.append(" <= ");
            str.append(DataTypeUtils.valueToString(cv.getType(), cv.getValueObject()));
            str.append(",");
        }
        if (!this.values.getColumnValues().isEmpty()) {
            str.setLength(str.length() - 1);
        }
        str.append(" into ");
        str.append(this.tableName);
        return str.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LAppend)) {
            return false;
        }
        LAppend other = (LAppend)obj;
        if (!this.values.equals(other.values)) {
            return false;
        }
        if (this.where == null != (other.where == null)) {
            return false;
        }
        return this.where == null || this.where.equals(other.where);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        assert (this.where != null);
        assert (this.values != null);
        assert (!this.values.getColumnValues().isEmpty());
        try {
            super.writeTo(out);
            out.writeBoolean(this.returnResults);
            WritableUtils.writeVInt(out, ExpressionType.getOrdinal(this.where));
            this.where.writeTo(out);
            this.values.writeTo(out);
        }
        catch (Throwable t) {
            throw new IllegalRequestException(t);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.returnResults = in.readBoolean();
        this.where = (Condition)ExpressionType.fromOrdinal(WritableUtils.readVInt(in));
        assert (this.where != null);
        this.where.readFrom(in);
        this.values = new Row();
        this.values.readFrom(in);
    }

    private boolean isEmpty() {
        return this.values == null || this.values.getColumnValues().isEmpty();
    }

    private static void validate(LAppend append2) throws LindormException {
        if (append2.getTableName() == null || append2.getTableName().isEmpty()) {
            throw new IllegalRequestException("Table name must not be null or empty.");
        }
        if (append2.getWhere() == null) {
            throw new IllegalRequestException("WHERE clause must not be null or empty for INCREASE.");
        }
    }

    private class AsyncAppendHandler
    extends DmlOperation.AsyncLMutationResultHandler<Row> {
        public AsyncAppendHandler(AsyncCallback<Row> callback, OperationContext.OperationType operationType, long startTime, Object eagleEyeContext) {
            super(LAppend.this, callback, operationType, startTime, eagleEyeContext);
        }

        @Override
        protected Row getReturnValue(LMutationResult result) {
            return (Row)result.getResults()[0];
        }
    }
}

