/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LBinary;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LVarbinary;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class LEncodedVarbinary
extends LDataType<byte[]> {
    public static final LEncodedVarbinary INSTANCE = new LEncodedVarbinary();

    private LEncodedVarbinary() {
        super(DataType.ENCODED_VARBINARY, byte[].class);
    }

    @Override
    public int getByteSize() {
        throw new UnsupportedOperationException("LEncodedVarbinary is variable length");
    }

    @Override
    public int getByteSize(Object obj) {
        return obj == null ? 0 : ((byte[])obj).length;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType == INSTANCE || targetType == LVarbinary.INSTANCE || targetType == LBinary.INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        byte[] v = (byte[])value;
        return DataTypeUtils.encodeEVarbinary(v, 0, v.length, sortOrder);
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (actualType == INSTANCE) {
            return value;
        }
        return actualType.toBytes(value);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) {
        return DataTypeUtils.decodeEVarbinary(value, offset, length, sortOrder);
    }

    @Override
    public byte[] getNullValue() throws IllegalDataException {
        byte[] ret = new byte[]{0};
        return this.toBytes(ret);
    }
}

