/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.utils.UnsafeUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;

public class FutureSynchonizer {
    private volatile Object value = null;
    private volatile Thread blocker = null;
    private static final long BLOCKER = UnsafeUtil.fieldOffset(FutureSynchonizer.class, "blocker");
    private static final long VALUE = UnsafeUtil.fieldOffset(FutureSynchonizer.class, "value");
    private static final long MAX_PARKTIME = TimeUnit.DAYS.toNanos(1L);
    private static final Object VOID_VALUE = new Object();

    public void done() {
        this.done(VOID_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (!UnsafeUtil.unsafe.compareAndSwapObject(this, VALUE, null, value)) {
            throw new IllegalStateException("Should not done twice.");
        }
        Thread blockedThread = this.blocker;
        if (blockedThread != null) {
            LockSupport.unpark(blockedThread);
            FutureSynchonizer futureSynchonizer = this;
            synchronized (futureSynchonizer) {
                this.notify();
            }
        }
    }

    public boolean isDone() {
        return this.value != null;
    }

    public Object getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        if (this.value != null) {
            return;
        }
        Thread cur = Thread.currentThread();
        if (UnsafeUtil.unsafe.compareAndSwapObject(this, BLOCKER, null, cur)) {
            try {
                while (this.value == null) {
                    LockSupport.park(this);
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException();
                }
            }
            finally {
                this.blocker = null;
            }
        }
        FutureSynchonizer futureSynchonizer = this;
        synchronized (futureSynchonizer) {
            this.wait();
        }
    }

    public void await(long time, TimeUnit tu) throws InterruptedException, TimeoutException {
        this.tryWait(time, tu);
        if (this.value == null) {
            throw new TimeoutException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryWait(long time, TimeUnit tu) throws InterruptedException {
        if (this.value != null) {
            return;
        }
        Thread cur = Thread.currentThread();
        if (UnsafeUtil.unsafe.compareAndSwapObject(this, BLOCKER, null, cur)) {
            try {
                long resttime = tu.toNanos(time);
                boolean restTimeIsNanos = true;
                if (resttime == Long.MIN_VALUE) {
                    resttime = tu.toMillis(time);
                    if (resttime == Long.MIN_VALUE) {
                        resttime = Long.MAX_VALUE;
                    }
                    restTimeIsNanos = false;
                }
                while (resttime > 0L && this.value == null) {
                    long start = System.nanoTime();
                    LockSupport.parkNanos(this, Math.min(resttime, MAX_PARKTIME));
                    long took = System.nanoTime() - start;
                    resttime -= restTimeIsNanos ? took : Math.max(1L, TimeUnit.NANOSECONDS.toMillis(took));
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException();
                }
            }
            finally {
                this.blocker = null;
            }
        }
        FutureSynchonizer futureSynchonizer = this;
        synchronized (futureSynchonizer) {
            this.wait(tu.toMillis(time));
        }
    }
}

