/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectionUtils {
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = new ConcurrentHashMap();
    private static ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();

    public static <T> T newInstance(Class<T> theClass) {
        Object result;
        try {
            Constructor<Object> meth = CONSTRUCTOR_CACHE.get(theClass);
            if (meth == null) {
                meth = theClass.getDeclaredConstructor(EMPTY_ARRAY);
                meth.setAccessible(true);
                CONSTRUCTOR_CACHE.put(theClass, meth);
            }
            result = meth.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    private static String getTaskName(long id, String name) {
        if (name == null) {
            return Long.toString(id);
        }
        return id + " (" + name + ")";
    }

    public static void printThreadInfo(PrintWriter stream, String title) {
        int STACK_DEPTH = 20;
        boolean contention = threadBean.isThreadContentionMonitoringEnabled();
        long[] threadIds = threadBean.getAllThreadIds();
        stream.println("Process Thread Dump: " + title);
        stream.println(threadIds.length + " active threads");
        for (long tid : threadIds) {
            ThreadInfo info = threadBean.getThreadInfo(tid, 20);
            if (info == null) {
                stream.println("  Inactive");
                continue;
            }
            stream.println("Thread " + ReflectionUtils.getTaskName(info.getThreadId(), info.getThreadName()) + ":");
            Thread.State state = info.getThreadState();
            stream.println("  State: " + (Object)((Object)state));
            stream.println("  Blocked count: " + info.getBlockedCount());
            stream.println("  Waited count: " + info.getWaitedCount());
            if (contention) {
                stream.println("  Blocked time: " + info.getBlockedTime());
                stream.println("  Waited time: " + info.getWaitedTime());
            }
            if (state == Thread.State.WAITING) {
                stream.println("  Waiting on " + info.getLockName());
            } else if (state == Thread.State.BLOCKED) {
                stream.println("  Blocked on " + info.getLockName());
                stream.println("  Blocked by " + ReflectionUtils.getTaskName(info.getLockOwnerId(), info.getLockOwnerName()));
            }
            stream.println("  Stack:");
            for (StackTraceElement frame : info.getStackTrace()) {
                stream.println("    " + frame.toString());
            }
        }
        stream.flush();
    }

    public static Object returnDefaultPrimitive(Class<?> declClass) {
        if (declClass == Boolean.TYPE) {
            return new Boolean(false);
        }
        if (declClass == Character.TYPE) {
            return new Character('\u0000');
        }
        if (declClass == Byte.TYPE) {
            return new Byte(0);
        }
        if (declClass == Short.TYPE) {
            return new Short(0);
        }
        if (declClass == Integer.TYPE) {
            return new Integer(0);
        }
        if (declClass == Long.TYPE) {
            return new Long(0L);
        }
        if (declClass == Float.TYPE) {
            return new Float(0.0f);
        }
        if (declClass == Double.TYPE) {
            return new Double(0.0);
        }
        if (declClass == Void.TYPE) {
            return null;
        }
        return null;
    }
}

