/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import sun.management.HotspotRuntimeMBean;
import sun.management.ManagementFactoryHelper;

public class VMPauseGuard {
    private final long totalPauseTimeAtBegin;
    private final long totalPauseCountAtBegin;
    private static VMPauseStatsProvider DEFAULT = new DefaultProvider();

    public VMPauseGuard() {
        VMPauseStats stats = VMPauseGuard.getVMPauseStats();
        this.totalPauseTimeAtBegin = stats.totalPauseTime;
        this.totalPauseCountAtBegin = stats.totalPauseCount;
    }

    public long pauseTime() {
        VMPauseStats stats = VMPauseGuard.getVMPauseStats();
        return Math.max(stats.totalPauseTime - this.totalPauseTimeAtBegin, 0L);
    }

    public long pauseCount() {
        VMPauseStats stats = VMPauseGuard.getVMPauseStats();
        return Math.max(stats.totalPauseCount - this.totalPauseCountAtBegin, 0L);
    }

    public static VMPauseStats getVMPauseStats() {
        return DEFAULT.get();
    }

    private static class DefaultProvider
    implements VMPauseStatsProvider {
        private long cachedTotalSafepointTime = -1L;
        private long cachedSafepointCount = -1L;
        private long lastUpdateTime = -1L;

        private DefaultProvider() {
        }

        private void readFromHotspotRuntime() {
            HotspotRuntimeMBean runtime = ManagementFactoryHelper.getHotspotRuntimeMBean();
            this.cachedSafepointCount = runtime.getSafepointCount();
            this.cachedTotalSafepointTime = runtime.getTotalSafepointTime();
        }

        @Override
        public VMPauseStats get() {
            long now = System.currentTimeMillis();
            if (now > this.lastUpdateTime) {
                this.readFromHotspotRuntime();
                this.lastUpdateTime = now;
            }
            return new VMPauseStats(this.cachedTotalSafepointTime, this.cachedSafepointCount);
        }
    }

    public static interface VMPauseStatsProvider {
        public VMPauseStats get();
    }

    public static class VMPauseStats {
        public long totalPauseTime;
        public long totalPauseCount;

        public VMPauseStats(long totalPauseTime, long totalPauseCount) {
            this.totalPauseTime = totalPauseTime;
            this.totalPauseCount = totalPauseCount;
        }
    }
}

