/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.core.LindormWideColumnService;
import com.alibaba.lindorm.client.core.widecolumnservice.WPartialResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WScan;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.Iterator;
import java.util.LinkedList;

public class WScanner
implements Iterable<WResult> {
    private LinkedList<WResult> cache = new LinkedList();
    private WScan wScan;
    private String tableName;
    private boolean needLoadingCache = true;
    private LindormWideColumnService wideColumnService;

    public WScanner(LindormWideColumnService wideColumnService, WScan wScan, String tableName) {
        this.wideColumnService = wideColumnService;
        this.wScan = wScan;
        this.tableName = tableName;
    }

    @Override
    public Iterator<WResult> iterator() {
        return new Iterator<WResult>(){
            WResult next = null;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    try {
                        this.next = WScanner.this.next();
                        return this.next != null;
                    }
                    catch (LindormException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            }

            @Override
            public WResult next() {
                if (!this.hasNext()) {
                    return null;
                }
                WResult temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void loadCache() throws LindormException {
        WPartialResult result = this.wideColumnService.scan(this.tableName, this.wScan);
        if (result != null && result.getResults() != null) {
            this.cache.addAll(result.getResults());
        }
        if (result == null || result.getNextStartKey() == null) {
            this.needLoadingCache = false;
        } else {
            this.wScan.setStartRowKey(result.getNextStartKey());
            this.wScan.setResumeRow(result.getResumeRow());
            this.wScan.setOffset(this.wScan.getOffset() - result.getSkipped());
        }
    }

    public WResult next() throws LindormException {
        while (this.needLoadingCache && this.cache.size() == 0) {
            this.loadCache();
        }
        if (!this.cache.isEmpty()) {
            return this.cache.poll();
        }
        return null;
    }
}

